/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.event;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.common.network.Networking;
import com.github.ars_affinity.common.network.ParticleEffectPacket;
import com.github.ars_affinity.event.ParticleUpdateScheduler;
import com.github.ars_affinity.event.SchoolAffinityPointAllocatedEvent;
import com.github.ars_affinity.registry.ModSounds;
import com.github.ars_affinity.util.SchoolColors;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;

public class SchoolAffinityPointAllocatedEvents {
    private static final Map<SpellSchool, SoundEvent> SCHOOL_SOUNDS = new HashMap<SpellSchool, SoundEvent>();

    @SubscribeEvent
    public static void onPointAllocated(SchoolAffinityPointAllocatedEvent event) {
        if (!event.hasPointsGained()) {
            return;
        }
        Player player = event.getPlayer();
        SpellSchool school = event.getSchool();
        int pointsGained = event.getPointsGained();
        if (player.level().isClientSide()) {
            return;
        }
        SchoolAffinityPointAllocatedEvents.sendPointAllocatedMessage(player, school, pointsGained);
        SchoolAffinityPointAllocatedEvents.playPointAllocatedSound(player, school);
        SchoolAffinityPointAllocatedEvents.spawnPointAllocatedParticles(player, school, pointsGained);
    }

    private static void sendPointAllocatedMessage(Player player, SpellSchool school, int pointsGained) {
        int hexColor = SchoolColors.getHexColor(school);
        ChatFormatting color = SchoolAffinityPointAllocatedEvents.getChatFormattingFromHex(hexColor);
        String schoolDisplayName = SchoolAffinityPointAllocatedEvents.getSchoolDisplayName(school);
        MutableComponent schoolName = Component.literal((String)schoolDisplayName).withStyle(color);
        String messageText = String.format("Gained %d %s affinity point%s!", pointsGained, schoolDisplayName, pointsGained == 1 ? "" : "s");
        MutableComponent message = Component.literal((String)("Gained " + pointsGained + " ")).append((Component)schoolName).append((Component)Component.literal((String)(" affinity point" + (pointsGained == 1 ? "" : "s") + "!")));
        PortUtil.sendMessage((Entity)player, (Component)message);
        ArsAffinity.LOGGER.debug("Sent point allocation message to player {}: {} points in {} school", (Object)player.getName().getString(), (Object)pointsGained, (Object)school.getId());
    }

    private static ChatFormatting getChatFormattingFromHex(int hexColor) {
        return switch (hexColor) {
            case -1022362 -> ChatFormatting.RED;
            case -8215827 -> ChatFormatting.BLUE;
            case -10296682 -> ChatFormatting.GREEN;
            case -2830502 -> ChatFormatting.YELLOW;
            case -30720 -> ChatFormatting.GOLD;
            case -1344306 -> ChatFormatting.LIGHT_PURPLE;
            case -9605779 -> ChatFormatting.DARK_GRAY;
            case -9772082 -> ChatFormatting.AQUA;
            default -> ChatFormatting.WHITE;
        };
    }

    private static String getSchoolDisplayName(SpellSchool school) {
        if (school == SpellSchools.NECROMANCY) {
            return "anima";
        }
        return school.getId().toString().replaceAll("_", " ");
    }

    private static void playPointAllocatedSound(Player player, SpellSchool school) {
        SoundEvent schoolSound = SCHOOL_SOUNDS.get(school);
        if (schoolSound == null) {
            ArsAffinity.LOGGER.warn("No sound found for school: " + school.getId());
            return;
        }
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), schoolSound, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private static void spawnPointAllocatedParticles(Player player, SpellSchool school, int pointsGained) {
        ArsAffinity.LOGGER.debug("=== SPAWNING POINT ALLOCATED PARTICLES ===");
        ArsAffinity.LOGGER.debug("spawnPointAllocatedParticles called for player {} school {} points {}", (Object)player.getName().getString(), (Object)school.getId(), (Object)pointsGained);
        ArsAffinity.LOGGER.debug("Player position: ({}, {}, {})", (Object)player.getX(), (Object)player.getY(), (Object)player.getZ());
        ArsAffinity.LOGGER.debug("Player level: {}, isClientSide: {}", (Object)player.level().dimension().location(), (Object)player.level().isClientSide());
        int particleCount = 3 + pointsGained * 2;
        ArsAffinity.LOGGER.debug("Calculated particle count: {} (base 5 + points {} * 3)", (Object)particleCount, (Object)pointsGained);
        ArsAffinity.LOGGER.debug("Creating ParticleEffectPacket with playerId={}, schoolId={}, particleCount={}", (Object)player.getId(), (Object)school.getId().toString(), (Object)particleCount);
        ParticleEffectPacket packet = new ParticleEffectPacket(player.getId(), school.getId().toString(), particleCount);
        ArsAffinity.LOGGER.debug("ParticleEffectPacket created successfully");
        ArsAffinity.LOGGER.debug("Sending particle packet to nearby clients at position: {}", (Object)player.blockPosition());
        try {
            Networking.sendToNearbyClient(player.level(), player.blockPosition(), (CustomPacketPayload)packet);
            ArsAffinity.LOGGER.debug("Particle packet sent successfully to nearby clients");
            ParticleUpdateScheduler.startPositionUpdates(player, school.getId().toString());
        }
        catch (Exception e) {
            ArsAffinity.LOGGER.error("Failed to send particle packet: {}", (Object)e.getMessage(), (Object)e);
        }
        ArsAffinity.LOGGER.debug("Spawning {} spiral particles for {} point allocation (+{} points)", (Object)particleCount, (Object)school.getId(), (Object)pointsGained);
        ArsAffinity.LOGGER.debug("=== PARTICLE SPAWNING COMPLETE ===");
    }

    static {
        SCHOOL_SOUNDS.put(SpellSchools.ELEMENTAL_FIRE, (SoundEvent)ModSounds.TIER_CHANGE_FIRE.get());
        SCHOOL_SOUNDS.put(SpellSchools.ELEMENTAL_WATER, (SoundEvent)ModSounds.TIER_CHANGE_WATER.get());
        SCHOOL_SOUNDS.put(SpellSchools.ELEMENTAL_EARTH, (SoundEvent)ModSounds.TIER_CHANGE_EARTH.get());
        SCHOOL_SOUNDS.put(SpellSchools.ELEMENTAL_AIR, (SoundEvent)ModSounds.TIER_CHANGE_AIR.get());
        SCHOOL_SOUNDS.put(SpellSchools.ABJURATION, (SoundEvent)ModSounds.TIER_CHANGE_ABJURATION.get());
        SCHOOL_SOUNDS.put(SpellSchools.CONJURATION, (SoundEvent)ModSounds.TIER_CHANGE_CONJURATION.get());
        SCHOOL_SOUNDS.put(SpellSchools.NECROMANCY, (SoundEvent)ModSounds.TIER_CHANGE_NECROMANCY.get());
        SCHOOL_SOUNDS.put(SpellSchools.MANIPULATION, (SoundEvent)ModSounds.TIER_CHANGE_MANIPULATION.get());
    }
}

