/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.helper;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class MathUtils {
    @Nullable
    public static EntityHitResult getLookedAtEntity(Entity entity, double range) {
        Vec3 eyePos = entity.getEyePosition(1.0f);
        Vec3 lookVec = entity.getViewVector(1.0f);
        Vec3 targetPos = eyePos.add(lookVec.x * range, lookVec.y * range, lookVec.z * range);
        AABB searchBox = entity.getBoundingBox().expandTowards(lookVec.scale(range)).inflate(1.0, 1.0, 1.0);
        return MathUtils.traceEntities(entity, eyePos, targetPos, searchBox, e -> !e.isSpectator() && e.isPickable(), range);
    }

    @Nullable
    public static EntityHitResult traceEntities(Entity shooter, Vec3 startVec, Vec3 endVec, AABB boundingBox, Predicate<Entity> filter, double range) {
        Level level = shooter.level();
        double closestDistSq = range * range;
        Entity hitEntity = null;
        Vec3 hitVec = null;
        for (Entity target : level.getEntities(shooter, boundingBox, filter)) {
            Vec3 hitPos;
            double distSq;
            AABB targetBox = target.getBoundingBox().inflate((double)target.getPickRadius());
            Optional clipResult = targetBox.clip(startVec, endVec);
            if (targetBox.contains(startVec)) {
                hitEntity = target;
                hitVec = clipResult.orElse(startVec);
                closestDistSq = 0.0;
                continue;
            }
            if (!clipResult.isPresent() || !((distSq = startVec.distanceToSqr(hitPos = (Vec3)clipResult.get())) < closestDistSq)) continue;
            if (target.getRootVehicle() == shooter.getRootVehicle() && !target.canRiderInteract()) {
                if (closestDistSq != 0.0) continue;
                hitEntity = target;
                hitVec = hitPos;
                continue;
            }
            hitEntity = target;
            hitVec = hitPos;
            closestDistSq = distSq;
        }
        return hitEntity == null ? null : new EntityHitResult(hitEntity, hitVec);
    }
}

