/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.mixin;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.perk.AffinityPerk;
import com.github.ars_affinity.perk.AffinityPerkHelper;
import com.github.ars_affinity.perk.AffinityPerkType;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={LivingEntity.class})
public abstract class PlayerFrictionMixin {
    private static final Set<BlockState> COLD_WALKER_BLOCKS = Set.of(Blocks.ICE.defaultBlockState(), Blocks.BLUE_ICE.defaultBlockState(), Blocks.PACKED_ICE.defaultBlockState(), Blocks.FROSTED_ICE.defaultBlockState(), Blocks.SNOW.defaultBlockState(), Blocks.SNOW_BLOCK.defaultBlockState(), Blocks.POWDER_SNOW.defaultBlockState());

    @ModifyVariable(method={"travel(Lnet/minecraft/world/phys/Vec3;)V"}, at=@At(value="STORE"), ordinal=0)
    private float modifyFriction(float friction) {
        AffinityPerk perk;
        LivingEntity entity = (LivingEntity)this;
        if (!(entity instanceof Player)) {
            return friction;
        }
        Player player = (Player)entity;
        if (!player.onGround()) {
            return friction;
        }
        BlockPos groundPos = player.blockPosition().below();
        BlockState groundState = player.level().getBlockState(groundPos);
        BlockPos abovePos = player.blockPosition();
        BlockState aboveState = player.level().getBlockState(abovePos);
        if ((COLD_WALKER_BLOCKS.contains(groundState) || COLD_WALKER_BLOCKS.contains(aboveState)) && (perk = AffinityPerkHelper.getAllocatedPerk(player, AffinityPerkType.PASSIVE_COLD_WALKER)) instanceof AffinityPerk.AmountBasedPerk) {
            AffinityPerk.AmountBasedPerk amountPerk = (AffinityPerk.AmountBasedPerk)perk;
            float newFriction = 0.6f - amountPerk.amount * 0.6f;
            ArsAffinity.LOGGER.debug("Player {} has COLD_WALKER perk with amount {} - overriding ice/snow/powdered snow friction from {} to {}", (Object)player.getName().getString(), (Object)Float.valueOf(amountPerk.amount), (Object)Float.valueOf(friction), (Object)Float.valueOf(newFriction));
            return newFriction;
        }
        return friction;
    }
}

