/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.perk;

import com.github.ars_affinity.perk.AffinityPerk;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;

public class AffinityPerkDescriptionHelper {
    public static MutableComponent getPerkDescription(AffinityPerk perk) {
        String translationKey = "ars_affinity.perk." + perk.perk.name();
        switch (perk.perk) {
            case PASSIVE_MANA_TAP: 
            case PASSIVE_FIRE_THORNS: 
            case PASSIVE_HEALING_AMPLIFICATION: 
            case PASSIVE_COLD_WALKER: 
            case PASSIVE_SOULSPIKE: {
                if (perk instanceof AffinityPerk.AmountBasedPerk) {
                    AffinityPerk.AmountBasedPerk amountPerk = (AffinityPerk.AmountBasedPerk)perk;
                    return Component.translatable((String)translationKey, (Object[])new Object[]{(int)(amountPerk.amount * 100.0f)});
                }
                return Component.translatable((String)translationKey, (Object[])new Object[]{0});
            }
            case PASSIVE_SUMMON_HEALTH: {
                if (perk instanceof AffinityPerk.DurationBasedPerk) {
                    AffinityPerk.DurationBasedPerk durationPerk = (AffinityPerk.DurationBasedPerk)perk;
                    return Component.translatable((String)translationKey, (Object[])new Object[]{(int)(durationPerk.amount * 4.0f), durationPerk.time / 20});
                }
                return Component.translatable((String)translationKey, (Object[])new Object[]{0, 0});
            }
            case PASSIVE_SUMMONING_POWER: 
            case PASSIVE_ABJURATION_POWER: 
            case PASSIVE_AIR_POWER: 
            case PASSIVE_EARTH_POWER: 
            case PASSIVE_FIRE_POWER: 
            case PASSIVE_MANIPULATION_POWER: 
            case PASSIVE_ANIMA_POWER: 
            case PASSIVE_WATER_POWER: 
            case PASSIVE_ABJURATION_RESISTANCE: 
            case PASSIVE_CONJURATION_RESISTANCE: 
            case PASSIVE_AIR_RESISTANCE: 
            case PASSIVE_EARTH_RESISTANCE: 
            case PASSIVE_FIRE_RESISTANCE: 
            case PASSIVE_MANIPULATION_RESISTANCE: 
            case PASSIVE_ANIMA_RESISTANCE: 
            case PASSIVE_WATER_RESISTANCE: {
                if (perk instanceof AffinityPerk.AmountBasedPerk) {
                    AffinityPerk.AmountBasedPerk amountPerk = (AffinityPerk.AmountBasedPerk)perk;
                    return Component.translatable((String)translationKey, (Object[])new Object[]{(int)amountPerk.amount});
                }
                return Component.translatable((String)translationKey, (Object[])new Object[]{0});
            }
            case PASSIVE_SUMMON_DEFENSE: {
                if (perk instanceof AffinityPerk.DurationBasedPerk) {
                    AffinityPerk.DurationBasedPerk durationPerk = (AffinityPerk.DurationBasedPerk)perk;
                    return Component.translatable((String)translationKey, (Object[])new Object[]{(int)durationPerk.amount, durationPerk.time / 20});
                }
                return Component.translatable((String)translationKey, (Object[])new Object[]{0, 0});
            }
            case PASSIVE_DEFLECTION: 
            case PASSIVE_STONE_SKIN: {
                if (perk instanceof AffinityPerk.DurationBasedPerk) {
                    AffinityPerk.DurationBasedPerk durationPerk = (AffinityPerk.DurationBasedPerk)perk;
                    return Component.translatable((String)translationKey, (Object[])new Object[]{durationPerk.time / 20});
                }
                return Component.translatable((String)translationKey, (Object[])new Object[]{0});
            }
            case PASSIVE_HYDRATION: {
                if (perk instanceof AffinityPerk.DurationBasedPerk) {
                    AffinityPerk.DurationBasedPerk durationPerk = (AffinityPerk.DurationBasedPerk)perk;
                    return Component.translatable((String)translationKey, (Object[])new Object[]{(int)durationPerk.amount, durationPerk.time / 20});
                }
                return Component.translatable((String)translationKey, (Object[])new Object[]{0, 0});
            }
            case PASSIVE_LICH_FEAST: {
                if (perk instanceof AffinityPerk.LichFeastPerk) {
                    AffinityPerk.LichFeastPerk lichPerk = (AffinityPerk.LichFeastPerk)perk;
                    return Component.translatable((String)translationKey, (Object[])new Object[]{Float.valueOf(lichPerk.health), Float.valueOf(lichPerk.hunger)});
                }
                return Component.translatable((String)translationKey, (Object[])new Object[]{0, 0});
            }
            case PASSIVE_GHOST_STEP: {
                if (perk instanceof AffinityPerk.GhostStepPerk) {
                    AffinityPerk.GhostStepPerk ghostStepPerk = (AffinityPerk.GhostStepPerk)perk;
                    return Component.translatable((String)translationKey, (Object[])new Object[]{(int)(ghostStepPerk.amount * 100.0f), ghostStepPerk.time / 20, ghostStepPerk.cooldown / 20});
                }
                return Component.translatable((String)translationKey, (Object[])new Object[]{0, 0, 0});
            }
            case ACTIVE_ICE_BLAST: {
                if (perk instanceof AffinityPerk.ActiveAbilityPerk) {
                    AffinityPerk.ActiveAbilityPerk activePerk = (AffinityPerk.ActiveAbilityPerk)perk;
                    return Component.translatable((String)translationKey, (Object[])new Object[]{(int)(activePerk.manaCost * 100.0f), activePerk.cooldown / 20});
                }
                return Component.translatable((String)translationKey, (Object[])new Object[]{0, 0});
            }
            case ACTIVE_SWAP_ABILITY: {
                if (perk instanceof AffinityPerk.ActiveAbilityPerk) {
                    AffinityPerk.ActiveAbilityPerk activePerk = (AffinityPerk.ActiveAbilityPerk)perk;
                    return Component.translatable((String)translationKey, (Object[])new Object[]{(int)activePerk.manaCost, activePerk.cooldown / 20});
                }
                return Component.translatable((String)translationKey, (Object[])new Object[]{0, 0});
            }
            case ACTIVE_SANCTUARY: {
                if (perk instanceof AffinityPerk.ActiveAbilityPerk) {
                    AffinityPerk.ActiveAbilityPerk activePerk = (AffinityPerk.ActiveAbilityPerk)perk;
                    return Component.translatable((String)translationKey, (Object[])new Object[]{activePerk.cooldown / 20});
                }
                return Component.translatable((String)translationKey, (Object[])new Object[]{0});
            }
            case PASSIVE_UNSTABLE_SUMMONING: {
                if (perk instanceof AffinityPerk.UnstableSummoningPerk) {
                    AffinityPerk.UnstableSummoningPerk unstablePerk = (AffinityPerk.UnstableSummoningPerk)perk;
                    if (unstablePerk.entities != null && !unstablePerk.entities.isEmpty()) {
                        String entityNames = AffinityPerkDescriptionHelper.getEntityNames(unstablePerk.entities);
                        return Component.translatable((String)translationKey, (Object[])new Object[]{(int)(unstablePerk.chance * 100.0f), entityNames});
                    }
                    return Component.translatable((String)translationKey, (Object[])new Object[]{(int)(unstablePerk.chance * 100.0f), "unknown entities"});
                }
                return Component.translatable((String)translationKey, (Object[])new Object[]{0, "unknown entities"});
            }
            case PASSIVE_ROTTING_GUISE: {
                return Component.translatable((String)translationKey);
            }
        }
        return Component.translatable((String)translationKey, (Object[])new Object[]{0});
    }

    public static String getPerkPrefix(AffinityPerk perk) {
        return perk.isBuff ? "+ " : "- ";
    }

    private static String getEntityNames(List<String> entityIds) {
        return entityIds.stream().map(id -> EntityType.byString((String)id)).filter(Optional::isPresent).map(Optional::get).map(EntityType::getDescriptionId).map(key -> Component.translatable((String)key).getString()).collect(Collectors.joining(", "));
    }
}

