/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.perk;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.perk.AffinityPerkType;
import com.github.ars_affinity.perk.PerkCategory;
import com.github.ars_affinity.perk.PerkNode;
import com.github.ars_affinity.perk.PerkTreeManager;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import net.minecraft.nbt.CompoundTag;

public class PerkAllocation {
    private final PerkNode node;
    private final int pointsInvested;
    private final boolean isActive;

    public PerkAllocation(PerkNode node) {
        this.node = node;
        this.pointsInvested = node.getPointCost();
        this.isActive = true;
    }

    public PerkAllocation(PerkNode node, int pointsInvested, boolean isActive) {
        this.node = node;
        this.pointsInvested = pointsInvested;
        this.isActive = isActive;
    }

    public PerkNode getNode() {
        return this.node;
    }

    public String getNodeId() {
        return this.node.getId();
    }

    public AffinityPerkType getPerkType() {
        return this.node.getPerkType();
    }

    public SpellSchool getSchool() {
        return this.node.getSchool();
    }

    public int getTier() {
        return this.node.getTier();
    }

    public int getPointsInvested() {
        return this.pointsInvested;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public PerkCategory getCategory() {
        return this.node.getCategory();
    }

    public String getDisplayName() {
        return this.node.getDisplayName();
    }

    public String getDescription() {
        return this.node.getDescription();
    }

    public int getEffectiveLevel() {
        return this.node.getTier();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putString("nodeId", this.node.getId());
        tag.putInt("pointsInvested", this.pointsInvested);
        tag.putBoolean("isActive", this.isActive);
        return tag;
    }

    public static PerkAllocation deserializeNBT(CompoundTag tag) {
        String nodeId = tag.getString("nodeId");
        int pointsInvested = tag.getInt("pointsInvested");
        boolean isActive = tag.getBoolean("isActive");
        PerkNode node = PerkTreeManager.getNode(nodeId);
        if (node == null) {
            ArsAffinity.LOGGER.error("Failed to find PerkNode for ID: {}", (Object)nodeId);
            return null;
        }
        return new PerkAllocation(node, pointsInvested, isActive);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PerkAllocation that = (PerkAllocation)obj;
        return this.node.equals(that.node);
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    public String toString() {
        return "PerkAllocation{node=" + this.node.getId() + ", pointsInvested=" + this.pointsInvested + ", tier=" + this.node.getTier() + ", isActive=" + this.isActive + "}";
    }
}

