/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.perk;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.capability.PlayerAffinityData;
import com.github.ars_affinity.capability.PlayerAffinityDataHelper;
import com.github.ars_affinity.capability.PlayerAffinityDataProvider;
import com.github.ars_affinity.common.network.Networking;
import com.github.ars_affinity.common.network.PerkAllocationActionPacket;
import com.github.ars_affinity.perk.ActiveAbilityHelper;
import com.github.ars_affinity.perk.AffinityPerkType;
import com.github.ars_affinity.perk.GlyphPrerequisiteHelper;
import com.github.ars_affinity.perk.PerkAllocation;
import com.github.ars_affinity.perk.PerkNode;
import com.github.ars_affinity.perk.PerkTreeManager;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;

public class PerkAllocationManager {
    public static boolean canAllocate(Player player, String perkId) {
        PlayerAffinityData data = PlayerAffinityDataHelper.getPlayerAffinityData(player);
        if (data == null) {
            return false;
        }
        PerkNode node = PerkTreeManager.getNode(perkId);
        if (node == null) {
            return false;
        }
        if (data.isPerkAllocated(perkId)) {
            return false;
        }
        if (!data.canAllocatePerk(node)) {
            return false;
        }
        return !node.hasPrerequisiteGlyph() || GlyphPrerequisiteHelper.hasUnlockedGlyph(player, node.getPrerequisiteGlyph());
    }

    public static boolean hasDifferentActiveAbility(Player player, String perkId) {
        PlayerAffinityData data = PlayerAffinityDataHelper.getPlayerAffinityData(player);
        if (data == null) {
            return false;
        }
        PerkNode node = PerkTreeManager.getNode(perkId);
        if (node == null) {
            return false;
        }
        if (!ActiveAbilityHelper.isActiveAbility(node.getPerkType())) {
            return false;
        }
        AffinityPerkType currentActiveAbility = data.getCurrentActiveAbilityType();
        return currentActiveAbility != null && currentActiveAbility != node.getPerkType();
    }

    public static boolean allocatePoints(Player player, String perkId, int points) {
        if (!PerkAllocationManager.canAllocate(player, perkId)) {
            return false;
        }
        if (player.level().isClientSide) {
            Networking.sendToServer((CustomPacketPayload)new PerkAllocationActionPacket(perkId, points, true));
            return true;
        }
        PlayerAffinityData data = PlayerAffinityDataHelper.getPlayerAffinityData(player);
        if (data == null) {
            return false;
        }
        PerkNode node = PerkTreeManager.getNode(perkId);
        if (node == null) {
            return false;
        }
        boolean success = data.allocatePerk(node);
        if (success) {
            ArsAffinity.LOGGER.debug("Player {} allocated {} points to perk {}", (Object)player.getName().getString(), (Object)points, (Object)perkId);
            PlayerAffinityDataHelper.savePlayerData(player);
            PlayerAffinityDataProvider.syncToClient(player);
        }
        return success;
    }

    public static boolean deallocatePerk(Player player, String perkId) {
        if (player.level().isClientSide) {
            PlayerAffinityData clientData = PlayerAffinityDataHelper.getPlayerAffinityData(player);
            if (clientData == null) {
                return false;
            }
            if (!clientData.isPerkAllocated(perkId)) {
                return false;
            }
            Networking.sendToServer((CustomPacketPayload)new PerkAllocationActionPacket(perkId, 0, false));
            return true;
        }
        PlayerAffinityData data = PlayerAffinityDataHelper.getPlayerAffinityData(player);
        if (data == null) {
            return false;
        }
        if (!data.isPerkAllocated(perkId)) {
            return false;
        }
        if (PerkAllocationManager.hasDependentPerks(data, perkId)) {
            ArsAffinity.LOGGER.warn("Cannot deallocate perk {} - other perks depend on it", (Object)perkId);
            return false;
        }
        boolean success = data.deallocatePerk(perkId);
        if (success) {
            ArsAffinity.LOGGER.debug("Player {} deallocated perk {}", (Object)player.getName().getString(), (Object)perkId);
            PlayerAffinityDataHelper.savePlayerData(player);
            PlayerAffinityDataProvider.syncToClient(player);
        }
        return success;
    }

    public static Map<String, PerkAllocation> getAllocatedPerks(Player player, SpellSchool school) {
        PlayerAffinityData data = PlayerAffinityDataHelper.getPlayerAffinityData(player);
        if (data == null) {
            return new HashMap<String, PerkAllocation>();
        }
        HashMap<String, PerkAllocation> result = new HashMap<String, PerkAllocation>();
        for (PerkAllocation allocation : data.getAllAllocatedPerks()) {
            PerkNode node = PerkTreeManager.getNode(allocation.getNodeId());
            if (node == null || node.getSchool() != school) continue;
            result.put(allocation.getNodeId(), allocation);
        }
        return result;
    }

    public static Map<String, PerkAllocation> getAllAllocatedPerks(Player player) {
        PlayerAffinityData data = PlayerAffinityDataHelper.getPlayerAffinityData(player);
        if (data == null) {
            return new HashMap<String, PerkAllocation>();
        }
        HashMap<String, PerkAllocation> result = new HashMap<String, PerkAllocation>();
        for (PerkAllocation allocation : data.getAllAllocatedPerks()) {
            result.put(allocation.getNodeId(), allocation);
        }
        return result;
    }

    private static boolean hasDependentPerks(PlayerAffinityData data, String perkId) {
        PerkNode targetNode = PerkTreeManager.getNode(perkId);
        if (targetNode == null) {
            return false;
        }
        SpellSchool school = targetNode.getSchool();
        for (PerkNode node : PerkTreeManager.getSchoolNodes(school).values()) {
            if (!node.getPrerequisites().contains(perkId) || !data.isPerkAllocated(node.getId())) continue;
            return true;
        }
        return false;
    }

    public static boolean resetSchoolPerks(Player player, SpellSchool school) {
        PlayerAffinityData data = PlayerAffinityDataHelper.getPlayerAffinityData(player);
        if (data == null) {
            return false;
        }
        Map<String, PerkAllocation> schoolPerks = PerkAllocationManager.getAllocatedPerks(player, school);
        for (String perkId : schoolPerks.keySet()) {
            data.deallocatePerk(perkId);
        }
        ArsAffinity.LOGGER.debug("Player {} reset all perks for school {}", (Object)player.getName().getString(), (Object)school.getId());
        return true;
    }

    public static int getTotalAllocatedCost(Player player, SpellSchool school) {
        Map<String, PerkAllocation> allocatedPerks = PerkAllocationManager.getAllocatedPerks(player, school);
        int totalCost = 0;
        for (PerkAllocation allocation : allocatedPerks.values()) {
            PerkNode node = PerkTreeManager.getNode(allocation.getNodeId());
            if (node == null) continue;
            totalCost += node.getPointCost();
        }
        return totalCost;
    }
}

