/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.perk;

import com.github.ars_affinity.perk.AffinityPerkType;
import com.github.ars_affinity.perk.PerkData;
import com.github.ars_affinity.perk.PerkRegistry;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import net.minecraft.nbt.CompoundTag;

public class PerkReference {
    private final AffinityPerkType perkType;
    private final SpellSchool sourceSchool;
    private final int sourceTier;

    public PerkReference(AffinityPerkType perkType, SpellSchool sourceSchool, int sourceTier) {
        this.perkType = perkType;
        this.sourceSchool = sourceSchool;
        this.sourceTier = sourceTier;
    }

    public AffinityPerkType getPerkType() {
        return this.perkType;
    }

    public SpellSchool getSourceSchool() {
        return this.sourceSchool;
    }

    public int getSourceTier() {
        return this.sourceTier;
    }

    public String getRegistryKey() {
        return String.format("%s_%s_%d", this.sourceSchool.getId().toString().toUpperCase().replace(":", "_"), this.perkType.name(), this.sourceTier);
    }

    public PerkData getPerkData() {
        return PerkRegistry.getPerk(this.getRegistryKey());
    }

    public boolean isValid() {
        return PerkRegistry.hasPerk(this.getRegistryKey());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PerkReference that = (PerkReference)obj;
        return this.sourceTier == that.sourceTier && this.perkType == that.perkType && this.sourceSchool.equals(that.sourceSchool);
    }

    public int hashCode() {
        int result = this.perkType.hashCode();
        result = 31 * result + this.sourceSchool.hashCode();
        result = 31 * result + this.sourceTier;
        return result;
    }

    public String toString() {
        return String.format("PerkReference{type=%s, school=%s, tier=%d}", new Object[]{this.perkType, this.sourceSchool.getId().toString().replace(":", "_"), this.sourceTier});
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putString("perkType", this.perkType.name());
        tag.putString("sourceSchool", PerkReference.getShortSchoolId(this.sourceSchool));
        tag.putInt("sourceTier", this.sourceTier);
        return tag;
    }

    public static PerkReference deserializeNBT(CompoundTag tag) {
        AffinityPerkType perkType = AffinityPerkType.valueOf(tag.getString("perkType"));
        String schoolId = tag.getString("sourceSchool");
        SpellSchool sourceSchool = PerkReference.getSpellSchoolFromId(schoolId);
        int sourceTier = tag.getInt("sourceTier");
        return new PerkReference(perkType, sourceSchool, sourceTier);
    }

    private static SpellSchool getSpellSchoolFromId(String id) {
        return switch (id) {
            case "ars_nouveau:elemental_fire" -> SpellSchools.ELEMENTAL_FIRE;
            case "ars_nouveau:elemental_water" -> SpellSchools.ELEMENTAL_WATER;
            case "ars_nouveau:elemental_earth" -> SpellSchools.ELEMENTAL_EARTH;
            case "ars_nouveau:elemental_air" -> SpellSchools.ELEMENTAL_AIR;
            case "ars_nouveau:abjuration" -> SpellSchools.ABJURATION;
            case "ars_nouveau:necromancy" -> SpellSchools.NECROMANCY;
            case "ars_nouveau:conjuration" -> SpellSchools.CONJURATION;
            case "ars_nouveau:manipulation" -> SpellSchools.MANIPULATION;
            case "fire" -> SpellSchools.ELEMENTAL_FIRE;
            case "water" -> SpellSchools.ELEMENTAL_WATER;
            case "earth" -> SpellSchools.ELEMENTAL_EARTH;
            case "air" -> SpellSchools.ELEMENTAL_AIR;
            default -> SpellSchools.ELEMENTAL_FIRE;
        };
    }

    private static String getShortSchoolId(SpellSchool school) {
        String schoolId;
        return switch (schoolId = school.getId().toString()) {
            case "ars_nouveau:elemental_fire" -> "fire";
            case "ars_nouveau:elemental_water" -> "water";
            case "ars_nouveau:elemental_earth" -> "earth";
            case "ars_nouveau:elemental_air" -> "air";
            case "ars_nouveau:abjuration" -> "abjuration";
            case "ars_nouveau:necromancy" -> "necromancy";
            case "ars_nouveau:conjuration" -> "conjuration";
            case "ars_nouveau:manipulation" -> "manipulation";
            default -> schoolId;
        };
    }
}

