/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.perk;

import com.github.ars_affinity.config.ArsAffinityConfig;

public class PointCalculationHelper {
    private PointCalculationHelper() {
    }

    public static float calculatePercentageIncrease(float mana, float currentPercentage, int totalPointsAcrossAllSchools) {
        float multiplier = ((Double)ArsAffinityConfig.AFFINITY_GAIN_MULTIPLIER.get()).floatValue();
        float basePercentageIncrease = mana * multiplier;
        float schoolDecayStrength = ((Double)ArsAffinityConfig.AFFINITY_SCALING_DECAY_STRENGTH.get()).floatValue();
        float schoolMinimumFactor = ((Double)ArsAffinityConfig.AFFINITY_SCALING_MINIMUM_FACTOR.get()).floatValue();
        float schoolScalingFactor = PointCalculationHelper.calculateScalingFactor((int)currentPercentage, schoolDecayStrength, schoolMinimumFactor);
        float globalDecayStrength = ((Double)ArsAffinityConfig.GLOBAL_SCALING_DECAY_STRENGTH.get()).floatValue();
        float globalMinimumFactor = ((Double)ArsAffinityConfig.GLOBAL_SCALING_MINIMUM_FACTOR.get()).floatValue();
        float globalScalingFactor = PointCalculationHelper.calculateScalingFactor(totalPointsAcrossAllSchools, globalDecayStrength, globalMinimumFactor);
        float combinedScalingFactor = schoolScalingFactor * globalScalingFactor;
        return Math.max(0.0f, basePercentageIncrease * combinedScalingFactor);
    }

    @Deprecated
    public static int calculatePointsGained(float mana, int currentPoints, int totalPointsAcrossAllSchools) {
        float percentageIncrease = PointCalculationHelper.calculatePercentageIncrease(mana, currentPoints, totalPointsAcrossAllSchools);
        return Math.max(0, Math.round(percentageIncrease / 10.0f));
    }

    public static int calculatePointsGained(float mana, int currentPoints) {
        return PointCalculationHelper.calculatePointsGained(mana, currentPoints, 0);
    }

    private static float calculateScalingFactor(int currentPoints, float decayStrength, float minimumFactor) {
        if (currentPoints <= 0) {
            return 1.0f;
        }
        double scaledPoints = Math.pow(currentPoints, decayStrength);
        float factor = (float)(1.0 / (1.0 + scaledPoints));
        return Math.max(minimumFactor, factor);
    }

    public static int calculateMaxPointsForSchool(int perkCount) {
        return perkCount;
    }

    public static int convertPercentageToPoints(float percentageAffinity, int maxPoints) {
        return Math.round(percentageAffinity * (float)maxPoints);
    }

    public static float convertPointsToPercentage(int currentPoints, int maxPoints) {
        if (maxPoints <= 0) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)currentPoints / (float)maxPoints);
    }
}

