/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.mob_effects;

import alexthw.ars_elemental.registry.ModPotions;
import com.alexthw.sauce.common.entity.EnthrallUtil;
import com.alexthw.sauce.util.EntityCarryMEI;
import java.util.Set;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.common.EffectCure;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import org.jetbrains.annotations.NotNull;

public class EnthrallEffect
extends MobEffect {
    public EnthrallEffect() {
        super(MobEffectCategory.NEUTRAL, 0);
        NeoForge.EVENT_BUS.addListener(this::onRemove);
    }

    private void onRemove(MobEffectEvent.Remove event) {
        event.getEntity().getPersistentData().remove("sauce:thrall");
    }

    public void onEffectAdded(@NotNull LivingEntity livingEntity, int amplifier) {
        super.onEffectAdded(livingEntity, amplifier);
        MobEffectInstance mobEffectInstance = livingEntity.getEffect(ModPotions.ENTHRALLED);
        if (mobEffectInstance instanceof EntityCarryMEI) {
            EntityCarryMEI mei = (EntityCarryMEI)mobEffectInstance;
            EnthrallUtil.permanentEnthrall((LivingEntity)mei.getOwner(), (LivingEntity)livingEntity);
        }
    }

    public boolean shouldApplyEffectTickThisTick(int pDuration, int pAmplifier) {
        return pDuration == 1;
    }

    public boolean applyEffectTick(@NotNull LivingEntity pLivingEntity, int pAmplifier) {
        pLivingEntity.getPersistentData().remove("sauce:thrall");
        return true;
    }

    public void fillEffectCures(@NotNull Set<EffectCure> cures, @NotNull MobEffectInstance effectInstance) {
    }
}

