/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.rituals;

import alexthw.ars_elemental.ArsElemental;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.entity.LightningEntity;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TeslaRitual
extends AbstractRitual {
    public static String ID = "ritual_tesla_coil";

    public String getLangName() {
        return "Zapping";
    }

    public String getLangDescription() {
        return "Calls lightning on entities that approach the ritual area of effect. Will target players if augmented with Air Essence. [11x7x11 cube centered on the brazier].";
    }

    protected void tick() {
        ServerLevel level;
        Level level2 = this.getWorld();
        if (level2 instanceof ServerLevel && (level = (ServerLevel)level2).getGameTime() % 100L == 0L && this.tile != null) {
            Predicate<LivingEntity> test = this.didConsumeItem((ItemLike)ItemsRegistry.AIR_ESSENCE) ? living -> true : living -> !(living instanceof Player);
            List entities = level.getEntitiesOfClass(LivingEntity.class, new AABB(this.tile.getBlockPos()).inflate(5.0, 3.0, 5.0), test);
            for (LivingEntity entity : entities) {
                Vec3 pos = entity.position();
                LightningEntity lightningBoltEntity = new LightningEntity((EntityType)ModEntities.LIGHTNING_ENTITY.get(), (Level)level);
                lightningBoltEntity.setPos(pos.x(), pos.y(), pos.z());
                lightningBoltEntity.setCause(null);
                level.addFreshEntity((Entity)lightningBoltEntity);
                this.setNeedsSource(true);
            }
        }
    }

    public boolean canConsumeItem(ItemStack stack) {
        return stack.getItem() == ItemsRegistry.AIR_ESSENCE.get();
    }

    public ParticleColor getCenterColor() {
        return new ParticleColor(100 + this.rand.nextInt(155), 50 + this.rand.nextInt(200), this.rand.nextInt(25));
    }

    public int getSourceCost() {
        return 500;
    }

    public ResourceLocation getRegistryName() {
        return ArsElemental.prefix(ID);
    }
}

