/*
 * Decompiled with CFR 0.152.
 */
package com.alexthw.ars_hex.hexerei;

import com.alexthw.ars_hex.ArsHex;
import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.documentation.DocClientUtils;
import com.hollingsworth.arsnouveau.api.documentation.SinglePageCtor;
import com.hollingsworth.arsnouveau.api.documentation.entry.PedestalRecipeEntry;
import com.hollingsworth.arsnouveau.api.documentation.export.DocExporter;
import com.hollingsworth.arsnouveau.client.gui.documentation.BaseDocScreen;
import java.util.Arrays;
import net.joefoxe.hexerei.data.recipes.FluidMixingRecipe;
import net.joefoxe.hexerei.data.recipes.MixingCauldronRecipe;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;

public class CauldronEntry
extends PedestalRecipeEntry {
    RecipeHolder<? extends MixingCauldronRecipe> cauldronRecipe;
    FluidIngredient reagentFluidStack;

    public CauldronEntry(RecipeHolder<? extends MixingCauldronRecipe> recipe, BaseDocScreen parent, int x, int y, int width, int height) {
        super(parent, x, y, width, height);
        this.cauldronRecipe = recipe;
        this.title = Component.translatable((String)"block.hexerei.mixing_cauldron");
        this.image = new DocAssets.BlitInfo(((MixingCauldronRecipe)recipe.value()).getHeatCondition() == FluidMixingRecipe.HeatCondition.NONE ? ArsHex.prefix("textures/gui/documentation/doc_detail_mixing_cauldron.png") : ArsHex.prefix("textures/gui/documentation/doc_detail_mixing_cauldron_heated.png"), 92, 127);
        if (recipe != null && recipe.value() != null) {
            this.outputStack = ((MixingCauldronRecipe)recipe.value()).getOutput();
            this.ingredients = ((MixingCauldronRecipe)recipe.value()).getIngredients();
            this.reagentFluidStack = ((MixingCauldronRecipe)recipe.value()).getFluidIngredient();
        }
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        if (!this.reagentFluidStack.isEmpty()) {
            int itemX = this.getX() + this.width / 2 - 6;
            int itemY = this.getY() + 24 + 20;
            this.setTooltipIfHovered(DocClientUtils.renderIngredient((GuiGraphics)guiGraphics, (int)itemX, (int)itemY, (int)mouseX, (int)mouseY, (Ingredient)Ingredient.of(Arrays.stream(this.reagentFluidStack.getStacks()).map(i -> i.getFluid().getBucket().getDefaultInstance()))));
        }
    }

    public static SinglePageCtor create(RecipeHolder<? extends MixingCauldronRecipe> recipe) {
        return (parent, x, y, width, height) -> new CauldronEntry(recipe, parent, x, y, width, height);
    }

    public void addExportProperties(JsonObject object) {
        super.addExportProperties(object);
        if (this.cauldronRecipe != null) {
            object.addProperty(DocExporter.RECIPE_PROPERTY, this.cauldronRecipe.id().toString());
        }
    }
}

