/*
 * Decompiled with CFR 0.152.
 */
package com.alexthw.ars_hex.hexerei.broom;

import com.alexthw.ars_hex.hexerei.HexereiCompat;
import com.hollingsworth.arsnouveau.api.spell.SpellCaster;
import com.hollingsworth.arsnouveau.common.util.ANCodecs;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.joefoxe.hexerei.client.renderer.entity.custom.BroomEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnchanterBroomEntity
extends BroomEntity {
    @Nullable
    private SpellCaster spellCaster;

    public EnchanterBroomEntity(EntityType<BroomEntity> broomEntityEntityType, Level world) {
        super(broomEntityEntityType, world);
    }

    public EnchanterBroomEntity(Level world, double x, double y, double z) {
        super((EntityType)HexereiCompat.ARCHWOOD_BROOM_ENTITY.get(), world);
        this.setPos(x, y, z);
        this.setDeltaMovement(Vec3.ZERO);
        this.xo = x;
        this.yo = y;
        this.zo = z;
        this.speedMultiplier = this.getBroomType().speedMultiplier();
    }

    @NotNull
    public EntityType<?> getType() {
        return (EntityType)HexereiCompat.ARCHWOOD_BROOM_ENTITY.get();
    }

    public boolean save(CompoundTag compound) {
        if (this.spellCaster != null) {
            compound.put("spell_caster", ANCodecs.encode((Codec)SpellCaster.CODEC.codec(), (Object)this.spellCaster));
        }
        return super.save(compound);
    }

    public void load(CompoundTag compound) {
        super.load(compound);
        if (compound.contains("spell_caster")) {
            this.spellCaster = (SpellCaster)ANCodecs.decode((Codec)SpellCaster.CODEC.codec(), (Tag)compound.get("spell_caster"));
        }
    }

    public void setSpellCaster(@Nullable SpellCaster spellCaster) {
        this.spellCaster = spellCaster;
    }

    @Nullable
    public SpellCaster getSpellCaster() {
        return this.spellCaster;
    }

    @NotNull
    public ItemStack getPickResult() {
        ItemStack broom = super.getPickResult();
        broom.set((Supplier)DataComponentRegistry.SPELL_CASTER, (Object)this.spellCaster);
        return broom;
    }
}

