/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.documentation.entry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.documentation.DocClientUtils;
import com.hollingsworth.arsnouveau.api.documentation.SinglePageCtor;
import com.hollingsworth.arsnouveau.api.documentation.SinglePageWidget;
import com.hollingsworth.arsnouveau.api.documentation.entry.DocEntry;
import com.hollingsworth.arsnouveau.api.documentation.export.DocExporter;
import com.hollingsworth.arsnouveau.api.registry.DocumentationRegistry;
import com.hollingsworth.arsnouveau.client.gui.documentation.BaseDocScreen;
import com.hollingsworth.arsnouveau.client.gui.documentation.DocEntryButton;
import com.hollingsworth.arsnouveau.client.gui.documentation.PageHolderScreen;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class RelationEntry
extends SinglePageWidget {
    public List<ResourceLocation> relatedEntries = new ArrayList<ResourceLocation>();

    public RelationEntry(BaseDocScreen parent, int x, int y, int width, int height) {
        super(parent, x, y, width, height);
    }

    public RelationEntry(List<ResourceLocation> relatedEntries, BaseDocScreen parent, int x, int y, int width, int height) {
        super(parent, x, y, width, height);
        this.relatedEntries = relatedEntries;
    }

    public static SinglePageCtor create() {
        return (parent, x, y, width, height) -> new RelationEntry(parent, x, y, width, height);
    }

    public static SinglePageCtor create(List<ResourceLocation> relatedEntries) {
        return (parent, x, y, width, height) -> new RelationEntry(relatedEntries, parent, x, y, width, height);
    }

    @Override
    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        DocClientUtils.drawHeader((Component)Component.translatable((String)"ars_nouveau.doc.related_entries"), guiGraphics, this.x, this.y, this.width, mouseX, mouseY, partialTick);
    }

    @Override
    public List<AbstractWidget> getExtras() {
        List<AbstractWidget> entryButtons = super.getExtras();
        int i = 0;
        for (ResourceLocation id : this.relatedEntries) {
            DocEntry entry = DocumentationRegistry.getEntry(id);
            DocEntryButton button = new DocEntryButton(this.x, this.y + 16 + 16 * i, entry, b -> this.parent.transition(new PageHolderScreen(entry)));
            entryButtons.add((AbstractWidget)button);
            ++i;
        }
        return entryButtons;
    }

    @Override
    public void addExportProperties(JsonObject object) {
        super.addExportProperties(object);
        JsonArray array = new JsonArray();
        for (ResourceLocation id : this.relatedEntries) {
            array.add(id.toString());
        }
        object.add(DocExporter.RELATED_PROPERTY, (JsonElement)array);
    }

    public static class RelationBuilder
    implements SinglePageCtor {
        public List<ResourceLocation> entries = new ArrayList<ResourceLocation>();

        public RelationBuilder withEntry(DocEntry entry) {
            this.entries.add(entry.id());
            return this;
        }

        public RelationBuilder withEntries(List<DocEntry> entries) {
            this.entries.addAll(entries.stream().map(DocEntry::id).toList());
            return this;
        }

        @Override
        public SinglePageWidget create(BaseDocScreen parent, int x, int y, int width, int height) {
            return new RelationEntry(this.entries, parent, x, y, width, height);
        }
    }
}

