/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.particle;

import com.hollingsworth.arsnouveau.api.particle.configurations.properties.ColorProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.IPropertyType;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.ParticleTypeProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.PropMap;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.SoundProperty;
import com.hollingsworth.arsnouveau.api.registry.ParticlePropertyRegistry;
import com.hollingsworth.arsnouveau.client.registry.ModParticles;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class PropertyParticleOptions
implements ParticleOptions {
    public static final MapCodec<PropertyParticleOptions> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PropMap.CODEC.fieldOf("properties").forGetter(i -> i.map)).apply((Applicative)instance, PropertyParticleOptions::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PropertyParticleOptions> STREAM_CODEC = StreamCodec.of(PropertyParticleOptions::toNetwork, PropertyParticleOptions::fromNetwork);
    public PropMap map;

    public static void toNetwork(RegistryFriendlyByteBuf buf, PropertyParticleOptions data) {
        PropMap.STREAM_CODEC.encode((Object)buf, (Object)data.map);
    }

    public static PropertyParticleOptions fromNetwork(RegistryFriendlyByteBuf buffer) {
        PropMap propMap = (PropMap)PropMap.STREAM_CODEC.decode((Object)buffer);
        return new PropertyParticleOptions(propMap);
    }

    public PropertyParticleOptions() {
        this((ParticleType)ModParticles.NEW_GLOW_TYPE.get());
    }

    public PropertyParticleOptions(PropMap propMap) {
        this.map = propMap;
    }

    public PropertyParticleOptions(ParticleType<?> type) {
        this(new PropMap());
        this.map.set((IPropertyType)ParticlePropertyRegistry.TYPE_PROPERTY.get(), new ParticleTypeProperty(type, new PropMap()));
    }

    public ColorProperty colorProp() {
        ParticleTypeProperty typeProperty = (ParticleTypeProperty)this.map.get((IPropertyType)ParticlePropertyRegistry.TYPE_PROPERTY.get());
        if (typeProperty != null) {
            return typeProperty.getColor();
        }
        return new ColorProperty();
    }

    public SoundProperty soundProperty() {
        ParticleTypeProperty typeProperty = (ParticleTypeProperty)this.map.get((IPropertyType)ParticlePropertyRegistry.TYPE_PROPERTY.get());
        if (typeProperty != null) {
            return typeProperty.getSound();
        }
        return new SoundProperty();
    }

    public ParticleType<?> getType() {
        return this.map.getOrCreate((IPropertyType)ParticlePropertyRegistry.TYPE_PROPERTY.get(), () -> new ParticleTypeProperty((ParticleType)ModParticles.NEW_GLOW_TYPE.get(), new PropMap())).type();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyParticleOptions that = (PropertyParticleOptions)o;
        return Objects.equals(this.map, that.map);
    }

    public int hashCode() {
        return Objects.hashCode(this.map);
    }
}

