/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.perk;

import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.perk.PerkInstance;
import com.hollingsworth.arsnouveau.api.perk.PerkSlot;
import com.hollingsworth.arsnouveau.api.util.RomanNumber;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public interface IPerkHolder<T> {
    default public List<PerkInstance> getPerkInstances(ItemStack stack) {
        ArrayList<PerkInstance> perkInstances = new ArrayList<PerkInstance>();
        ArrayList<PerkSlot> slots = new ArrayList<PerkSlot>(this.getSlotsForTier(stack));
        List<IPerk> perks = this.getPerks();
        for (int i = 0; i < slots.size(); ++i) {
            if (i >= perks.size()) continue;
            perkInstances.add(new PerkInstance((PerkSlot)slots.get(i), perks.get(i)));
        }
        return perkInstances;
    }

    public List<IPerk> getPerks();

    public T setPerks(List<IPerk> var1);

    public List<PerkSlot> getSlotsForTier(ItemStack var1);

    default public boolean isEmpty() {
        return this.getPerks().isEmpty();
    }

    default public void appendPerkTooltip(List<Component> tooltip, ItemStack stack) {
        for (PerkInstance perkInstance : this.getPerkInstances(stack)) {
            IPerk perk = perkInstance.getPerk();
            ResourceLocation location = perk.getRegistryName();
            tooltip.add((Component)Component.literal((String)(Component.translatable((String)("item." + location.getNamespace() + "." + location.getPath())).getString() + " " + RomanNumber.toRoman(perkInstance.getSlot().value()))));
        }
        int missing = this.getSlotsForTier(stack).size() - this.getPerkInstances(stack).size();
        for (int i = 0; i < missing; ++i) {
            PerkSlot slot = new ArrayList<PerkSlot>(this.getSlotsForTier(stack)).subList(this.getPerkInstances(stack).size(), this.getSlotsForTier(stack).size()).get(i);
            tooltip.add((Component)Component.literal((String)(Component.translatable((String)"ars_nouveau.empty").getString() + " " + RomanNumber.toRoman(slot.value()))).withStyle(ChatFormatting.RED).withStyle(ChatFormatting.ITALIC));
        }
    }

    public int getTier();

    public T setTier(int var1);

    @Nullable
    public CompoundTag getTagForPerk(IPerk var1);

    public T setTagForPerk(IPerk var1, CompoundTag var2);
}

