/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class CuriosUtil {
    @Nullable
    public static IItemHandlerModifiable getAllWornItems(@NotNull LivingEntity living) {
        Optional curioInv = CuriosApi.getCuriosInventory((LivingEntity)living);
        return curioInv.map(ICuriosItemHandler::getEquippedCurios).orElse(null);
    }

    public static boolean hasItem(@Nullable LivingEntity entity, ItemStack stack) {
        if (entity == null) {
            return false;
        }
        IItemHandlerModifiable items = CuriosUtil.getAllWornItems(entity);
        if (items != null) {
            for (int i = 0; i < items.getSlots(); ++i) {
                if (!ItemStack.isSameItem((ItemStack)stack, (ItemStack)items.getStackInSlot(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasItem(LivingEntity entity, Item item) {
        return CuriosUtil.hasItem(entity, new ItemStack((ItemLike)item));
    }
}

