/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.events;

import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.api.registry.DynamicTooltipRegistry;
import com.hollingsworth.arsnouveau.api.registry.GenericRecipeRegistry;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.gui.DocItemTooltipHandler;
import com.hollingsworth.arsnouveau.client.gui.SchoolTooltip;
import com.hollingsworth.arsnouveau.client.gui.SpellTooltip;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.GuiRadialMenu;
import com.hollingsworth.arsnouveau.client.renderer.tile.PlanariumRenderer;
import com.hollingsworth.arsnouveau.client.renderer.world.PantomimeRenderer;
import com.hollingsworth.arsnouveau.common.block.ArchwoodChest;
import com.hollingsworth.arsnouveau.common.block.tile.ArchwoodChestTile;
import com.hollingsworth.arsnouveau.common.block.tile.GhostWeaveTile;
import com.hollingsworth.arsnouveau.common.block.tile.PlanariumTile;
import com.hollingsworth.arsnouveau.common.block.tile.SkyBlockTile;
import com.hollingsworth.arsnouveau.common.items.data.ReactiveCasterData;
import com.hollingsworth.arsnouveau.common.light.LightManager;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ContainerScreenEvent;
import net.neoforged.neoforge.client.event.RecipesUpdatedEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(value={Dist.CLIENT}, modid="ars_nouveau")
public class ClientEvents {
    private static Slot slotUnderMouse = null;
    public static final List<Predicate<RecipesUpdatedEvent>> recipeChangeListeners = new ArrayList<Predicate<RecipesUpdatedEvent>>();

    @SubscribeEvent
    public static void onRecipesUpdate(RecipesUpdatedEvent event) {
        GenericRecipeRegistry.reloadAll(event.getRecipeManager());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void renderWorldLastEvent(RenderLevelStageEvent event) {
        PlanariumTile tile;
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            LightManager.updateAll(event.getLevelRenderer());
        }
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            PantomimeRenderer.renderOutline(event.getPoseStack());
        }
        for (WeakReference<PlanariumTile> renderer : PlanariumRenderer.deferredRenders) {
            tile = (PlanariumTile)renderer.get();
            if (tile == null) continue;
            PlanariumRenderer.buildRender(tile, event.getPoseStack(), (Player)Minecraft.getInstance().player);
        }
        for (WeakReference<PlanariumTile> renderer : PlanariumRenderer.deferredRenders) {
            tile = (PlanariumTile)renderer.get();
            if (tile == null) continue;
            PlanariumRenderer.drawRender(tile, event.getPoseStack(), event.getProjectionMatrix(), event.getModelViewMatrix(), (Player)Minecraft.getInstance().player);
        }
        PlanariumRenderer.deferredRenders = new ArrayList<WeakReference<PlanariumTile>>(8);
    }

    @SubscribeEvent
    public static void TooltipEvent(RenderTooltipEvent.Pre e) {
        DocItemTooltipHandler.onTooltip(e.getGraphics(), e.getItemStack(), e.getX(), e.getY());
    }

    @SubscribeEvent
    public static void containerRenderBackground(ContainerScreenEvent.Render.Background e) {
        AbstractContainerScreen screen = e.getContainerScreen();
        slotUnderMouse = screen.getSlotUnderMouse();
    }

    @SubscribeEvent
    public static void containerRenderForeground(ContainerScreenEvent.Render.Foreground e) {
        AbstractContainerScreen screen = e.getContainerScreen();
        if (slotUnderMouse != screen.getSlotUnderMouse()) {
            DocItemTooltipHandler.resetLexiconLookupTime();
        }
    }

    @SubscribeEvent
    public static void addComponents(RenderTooltipEvent.GatherComponents event) {
        ReactiveCasterData caster;
        if (!Screen.hasShiftDown() && event.getItemStack().isEnchanted() && event.getItemStack().has(DataComponentRegistry.REACTIVE_CASTER) && (caster = (ReactiveCasterData)event.getItemStack().get(DataComponentRegistry.REACTIVE_CASTER)) != null && caster.getSpell().isValid()) {
            event.getTooltipElements().add(Either.right((Object)new SpellTooltip(caster)));
        }
        if (event.getItemStack().has(DataComponentRegistry.PRESTIDIGITATION)) {
            event.getTooltipElements().add(Either.left((Object)Component.translatable((String)"ars_nouveau.prestidigitation.tooltip")));
        }
    }

    @SubscribeEvent
    public static void highlightBlockEvent(RenderHighlightEvent.Block e) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            GhostWeaveTile ghostTile;
            SkyBlockTile skyTile;
            BlockEntity be = level.getBlockEntity(e.getTarget().getBlockPos());
            if (be instanceof SkyBlockTile && !(skyTile = (SkyBlockTile)be).showFacade()) {
                e.setCanceled(true);
            }
            if (be instanceof GhostWeaveTile && (ghostTile = (GhostWeaveTile)be).isInvisible()) {
                e.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void overlayEvent(RenderGuiLayerEvent.Pre event) {
        if (Minecraft.getInstance().screen instanceof GuiRadialMenu && event.getName().equals((Object)VanillaGuiLayers.CROSSHAIR)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        DynamicTooltipRegistry.appendTooltips(stack, event.getContext(), event.getToolTip()::add, event.getFlags());
        for (Component tooltip : ClientInfo.storageTooltip) {
            event.getToolTip().add(tooltip);
        }
    }

    public static Component localize(String key, Object ... params) {
        for (int i = 0; i < params.length; ++i) {
            Component component;
            ComponentContents componentContents;
            Object parameter = params[i];
            if (!(parameter instanceof Component) || !((componentContents = (component = (Component)parameter).getContents()) instanceof TranslatableContents)) continue;
            TranslatableContents translatableContents = (TranslatableContents)componentContents;
            params[i] = ClientEvents.localize(translatableContents.getKey(), translatableContents.getArgs());
        }
        return Component.translatable((String)key, (Object[])params);
    }

    @SubscribeEvent
    public static void onClientResourcesReload(RecipesUpdatedEvent event) {
        recipeChangeListeners.removeIf(p -> !p.test(event));
    }

    @SubscribeEvent
    public static void clientPlayerLogin(ClientPlayerNetworkEvent.LoggingIn e) {
        if (e.getPlayer() != null && ((Boolean)Config.INFORM_LIGHTS.get()).booleanValue()) {
            LocalPlayer entity = e.getPlayer();
            PortUtil.sendMessage((Entity)entity, (Component)Component.translatable((String)"ars_nouveau.light_message").withStyle(ChatFormatting.GOLD));
            Config.INFORM_LIGHTS.set((Object)false);
            Config.INFORM_LIGHTS.save();
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(ClientPlayerNetworkEvent.LoggingOut loggingOut) {
        EventQueue.getClientQueue().clear();
        PlanariumTile.dimManager.entries.clear();
        PlanariumRenderer.structureRenderData = new HashMap<ResourceKey<Level>, PlanariumRenderer.StructureRenderData>();
        PlanariumRenderer.deferredRenders = new ArrayList<WeakReference<PlanariumTile>>();
    }

    @EventBusSubscriber(value={Dist.CLIENT}, modid="ars_nouveau", bus=EventBusSubscriber.Bus.MOD)
    static class ClientModEvents {
        ClientModEvents() {
        }

        @SubscribeEvent
        public static void registerTooltipFactory(RegisterClientTooltipComponentFactoriesEvent event) {
            event.register(SpellTooltip.class, SpellTooltip.SpellTooltipRenderer::new);
            event.register(SchoolTooltip.class, SchoolTooltip.SchoolTooltipRenderer::new);
        }

        @SubscribeEvent
        public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
            event.registerItem(new IClientItemExtensions(){

                @NotNull
                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    final Minecraft mc = Minecraft.getInstance();
                    return new BlockEntityWithoutLevelRenderer(this, mc.getBlockEntityRenderDispatcher(), mc.getEntityModels()){
                        private final BlockEntity tile;
                        {
                            super(arg0, arg1);
                            this.tile = new ArchwoodChestTile(BlockPos.ZERO, ((ArchwoodChest)((Object)BlockRegistry.ARCHWOOD_CHEST.get())).defaultBlockState());
                        }

                        public void renderByItem(@NotNull ItemStack stack, @NotNull ItemDisplayContext transformType, @NotNull PoseStack pose, @NotNull MultiBufferSource buffer, int x, int y) {
                            mc.getBlockEntityRenderDispatcher().renderItem(this.tile, pose, buffer, x, y);
                        }
                    };
                }
            }, new Item[]{((ArchwoodChest)((Object)BlockRegistry.ARCHWOOD_CHEST.get())).asItem()});
        }
    }
}

