/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui.book;

import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.documentation.DocClientUtils;
import com.hollingsworth.arsnouveau.api.particle.configurations.ParticleConfigWidgetProvider;
import com.hollingsworth.arsnouveau.api.particle.timelines.IParticleTimelineType;
import com.hollingsworth.arsnouveau.api.particle.timelines.TimelineMap;
import com.hollingsworth.arsnouveau.api.registry.ParticleTimelineRegistry;
import com.hollingsworth.arsnouveau.api.registry.SpellCasterRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.client.gui.HeaderWidget;
import com.hollingsworth.arsnouveau.client.gui.book.GuiSpellBook;
import com.hollingsworth.arsnouveau.client.gui.book.PropWidgetList;
import com.hollingsworth.arsnouveau.client.gui.book.SpellSlottedScreen;
import com.hollingsworth.arsnouveau.client.gui.buttons.ClearButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.GlyphButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.GuiImageButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.PropertyButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.SelectableButton;
import com.hollingsworth.arsnouveau.client.gui.documentation.DocEntryButton;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateParticleTimeline;
import com.hollingsworth.arsnouveau.setup.registry.CreativeTabRegistry;
import com.hollingsworth.nuggets.client.gui.GuiHelpers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class ParticleOverviewScreen
extends SpellSlottedScreen {
    TimelineMap.MutableTimelineMap timelineMap;
    public IParticleTimelineType<?> selectedTimeline = null;
    List<AbstractWidget> rightPageWidgets = new ArrayList<AbstractWidget>();
    ParticleConfigWidgetProvider propertyWidgetProvider;
    DocEntryButton timelineButton;
    int rowOffset = 0;
    boolean hasMoreElements = false;
    boolean hasPreviousElements = false;
    public static IParticleTimelineType<?> LAST_SELECTED_PART = null;
    public static int lastOpenedHash;
    public static ParticleOverviewScreen lastScreen;
    GuiSpellBook previousScreen;
    GuiImageButton upButton;
    GuiImageButton downButton;
    boolean allExpanded = false;
    PropWidgetList propWidgetList;

    public ParticleOverviewScreen(GuiSpellBook previousScreen, int slot, InteractionHand stackHand) {
        super(stackHand);
        this.previousScreen = previousScreen;
        this.selectedSpellSlot = slot;
        this.timelineMap = this.caster.getParticles(slot).mutable();
        this.selectedTimeline = LAST_SELECTED_PART == null ? this.findTimelineFromSlot() : LAST_SELECTED_PART;
        LAST_SELECTED_PART = this.selectedTimeline;
    }

    public IParticleTimelineType<?> findTimelineFromSlot() {
        IParticleTimelineType timeline = null;
        for (AbstractSpellPart spellPart : this.caster.getSpell(this.selectedSpellSlot).recipe()) {
            Set allTimelines = ParticleTimelineRegistry.PARTICLE_TIMELINE_REGISTRY.entrySet();
            for (Map.Entry entry : allTimelines) {
                if (((IParticleTimelineType)entry.getValue()).getSpellPart() != spellPart) continue;
                timeline = (IParticleTimelineType)entry.getValue();
            }
            if (timeline == null) continue;
            break;
        }
        if (timeline == null) {
            timeline = (IParticleTimelineType)ParticleTimelineRegistry.PROJECTILE_TIMELINE.get();
        }
        return timeline;
    }

    public void initSlotChange() {
        this.timelineMap = this.caster.getParticles(this.selectedSpellSlot).mutable();
        this.selectedTimeline = this.findTimelineFromSlot();
        LAST_SELECTED_PART = this.selectedTimeline;
        this.rowOffset = 0;
        this.onTimelineSelectorHit();
    }

    @Override
    public void init() {
        super.init();
        this.propWidgetList = new PropWidgetList(this.bookLeft + 19 + 13, this.bookLeft + 153, this.bookTop + 17, this::onPropertySelected, this::onDependenciesChanged, this.propWidgetList);
        this.upButton = new GuiImageButton(this.bookLeft + 19 + 87, this.bookBottom - 30, DocAssets.BUTTON_UP, button -> {
            this.rowOffset = Math.max(this.rowOffset - 1, 0);
            this.layoutLeftPage();
        }).withHoverImage(DocAssets.BUTTON_UP_HOVER);
        this.downButton = new GuiImageButton(this.bookLeft + 19 + 103, this.bookBottom - 30, DocAssets.BUTTON_DOWN, button -> {
            ++this.rowOffset;
            this.layoutLeftPage();
        }).withHoverImage(DocAssets.BUTTON_DOWN_HOVER);
        this.addRenderableWidget((GuiEventListener)new ClearButton(this.bookRight - 129, this.bookBottom - 13, (Component)Component.translatable((String)"ars_nouveau.spell_book_gui.clear"), this::reset));
        this.addRenderableWidget((GuiEventListener)this.upButton);
        this.addRenderableWidget((GuiEventListener)this.downButton);
        this.addBackButton((Screen)this.previousScreen, b -> {
            GuiSpellBook patt0$temp = this.previousScreen;
            if (patt0$temp instanceof GuiSpellBook) {
                GuiSpellBook guiSpellBook = patt0$temp;
                guiSpellBook.selectedSpellSlot = this.selectedSpellSlot;
                guiSpellBook.onBookstackUpdated(this.bookStack);
            }
        });
        this.addSaveButton(b -> {
            lastOpenedHash = this.timelineMap.immutable().hashCode();
            Networking.sendToServer(new PacketUpdateParticleTimeline(this.selectedSpellSlot, this.timelineMap.immutable(), this.hand == InteractionHand.MAIN_HAND));
        });
        this.timelineButton = (DocEntryButton)this.addRenderableWidget((GuiEventListener)new DocEntryButton(this.bookLeft + 19, this.bookTop + 36, this.selectedTimeline.getSpellPart().glyphItem.getDefaultInstance(), (Component)Component.translatable((String)this.selectedTimeline.getSpellPart().getLocaleName()), b -> this.onTimelineSelectorHit()));
        this.timelineButton.isSelected = true;
        this.initLeftSideButtons();
        SelectableButton expandButton = new SelectableButton(this.bookLeft + 19 + 12, this.bookBottom - 30, DocAssets.EXPAND_ICON, DocAssets.COLLAPSE_ICON, button -> {
            boolean bl = this.allExpanded = !this.allExpanded;
            if (button instanceof SelectableButton) {
                SelectableButton selectableButton = (SelectableButton)button;
                selectableButton.isSelected = this.allExpanded;
            }
            this.layoutLeftPage();
        });
        expandButton.withTooltip((Component)Component.translatable((String)"ars_nouveau.expand_button"));
        expandButton.isSelected = this.allExpanded;
        this.addRenderableWidget((GuiEventListener)expandButton);
        this.initSpellSlots(slotButton -> {
            this.initSlotChange();
            this.rebuildWidgets();
        });
        PropertyButton lastClickedButton = this.propWidgetList.getSelectedButton();
        if (lastClickedButton != null) {
            lastClickedButton.onPress();
        } else {
            this.addTimelineSelectionWidgets();
        }
    }

    public void reset(Button button) {
        if (this.selectedTimeline == null) {
            return;
        }
        this.timelineMap.remove(this.selectedTimeline);
        this.onTimelineSelectorHit();
        this.initLeftSideButtons();
    }

    public void onDependenciesChanged(PropertyButton propButton) {
        this.initLeftSideButtons();
    }

    public void onTimelineSelectorHit() {
        this.timelineButton.isSelected = true;
        this.propWidgetList.resetSelected();
        this.addTimelineSelectionWidgets();
    }

    public static void openScreen(GuiSpellBook parentScreen, ItemStack stack, int slot, InteractionHand stackHand) {
        AbstractCaster<?> caster = SpellCasterRegistry.from(stack);
        int hash = caster.getSpell(slot).particleTimeline().hashCode();
        if (LAST_SELECTED_PART == null || lastOpenedHash != hash || lastScreen == null) {
            LAST_SELECTED_PART = null;
            lastOpenedHash = hash;
            Minecraft.getInstance().setScreen((Screen)new ParticleOverviewScreen(parentScreen, slot, stackHand));
        } else {
            ParticleOverviewScreen screen = lastScreen;
            if (screen.selectedSpellSlot != slot) {
                screen.selectedSpellSlot = slot;
                screen.initSlotChange();
            }
            parentScreen.selectedSpellSlot = slot;
            Minecraft.getInstance().setScreen((Screen)screen);
        }
    }

    public void onClose() {
        super.onClose();
        lastScreen = this;
    }

    public void removed() {
        super.removed();
        lastScreen = this;
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (this.propertyWidgetProvider != null && GuiHelpers.isMouseInRelativeRange((int)((int)pMouseX), (int)((int)pMouseY), (int)this.propertyWidgetProvider.x, (int)this.propertyWidgetProvider.y, (int)this.propertyWidgetProvider.width, (int)this.propertyWidgetProvider.height) && this.propertyWidgetProvider.mouseScrolled(pMouseX, pMouseY, pScrollX, pScrollY)) {
            return true;
        }
        SoundManager manager = Minecraft.getInstance().getSoundManager();
        if (pScrollY < 0.0 && this.hasMoreElements) {
            ++this.rowOffset;
            this.layoutLeftPage();
            manager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
        } else if (pScrollY > 0.0 && this.hasPreviousElements) {
            --this.rowOffset;
            this.layoutLeftPage();
            manager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
        }
        return true;
    }

    public void initLeftSideButtons() {
        this.clearList(this.propWidgetList.allButtons);
        Object timeline = this.timelineMap.getOrCreate(this.selectedTimeline);
        this.propWidgetList.init(timeline.getProperties());
        for (AbstractWidget abstractWidget : this.propWidgetList.allButtons) {
            this.addRenderableWidget((GuiEventListener)abstractWidget);
        }
        this.layoutLeftPage();
    }

    public void layoutLeftPage() {
        List expandedWidgets = this.propWidgetList.allButtons.stream().filter(widget -> {
            if (!(widget instanceof PropertyButton)) {
                return true;
            }
            PropertyButton propertyButton = widget;
            return this.allExpanded || propertyButton.isExpanded() || propertyButton.nestLevel == 0;
        }).collect(Collectors.toList());
        if (this.rowOffset >= expandedWidgets.size()) {
            this.rowOffset = 0;
        }
        int propIndex = 0;
        for (AbstractWidget abstractWidget : this.propWidgetList.allButtons) {
            abstractWidget.active = false;
            abstractWidget.visible = false;
            if (!(abstractWidget instanceof PropertyButton)) continue;
            PropertyButton button = (PropertyButton)abstractWidget;
            button.index = propIndex;
            button.showMarkers = !this.allExpanded;
            ++propIndex;
        }
        List slicedWidgets = expandedWidgets.subList(this.rowOffset, expandedWidgets.size());
        int n = 7;
        for (int i = 0; i < Math.min(slicedWidgets.size(), n); ++i) {
            AbstractWidget widget3 = (AbstractWidget)slicedWidgets.get(i);
            widget3.y = this.bookTop + 51 + 15 * i;
            widget3.active = true;
            widget3.visible = true;
        }
        this.hasMoreElements = this.rowOffset + n < expandedWidgets.size();
        this.upButton.visible = this.hasPreviousElements = this.rowOffset > 0;
        this.upButton.active = this.hasPreviousElements;
        this.downButton.active = this.hasMoreElements;
        this.downButton.visible = this.hasMoreElements;
    }

    public void onPropertySelected(PropertyButton propertyButton) {
        this.clearRightPage();
        this.timelineButton.isSelected = false;
        this.propertyWidgetProvider = propertyButton.property.buildWidgets(this.bookLeft + 153, this.bookTop + 17, 118, 146);
        ArrayList<AbstractWidget> propertyWidgets = new ArrayList<AbstractWidget>();
        this.propertyWidgetProvider.addWidgets(propertyWidgets);
        for (AbstractWidget widget : propertyWidgets) {
            this.addRightPageWidget(widget);
        }
        this.layoutLeftPage();
    }

    public void addTimelineSelectionWidgets() {
        this.clearRightPage();
        this.rightPageWidgets.add((AbstractWidget)this.addRenderableWidget((GuiEventListener)new HeaderWidget(this.bookLeft + 153, this.bookTop + 17, 118, 20, (Component)Component.translatable((String)"ars_nouveau.particle_timelines"))));
        ArrayList timelineList = new ArrayList(ParticleTimelineRegistry.PARTICLE_TIMELINE_REGISTRY.entrySet());
        timelineList.sort((o1, o2) -> CreativeTabRegistry.COMPARE_SPELL_TYPE_NAME.compare(((IParticleTimelineType)o1.getValue()).getSpellPart(), ((IParticleTimelineType)o2.getValue()).getSpellPart()));
        for (int i = 0; i < timelineList.size(); ++i) {
            Map.Entry entry = (Map.Entry)timelineList.get(i);
            GlyphButton widget = new GlyphButton(this.bookLeft + 153 + 2 + 20 * (i % 6), this.bookTop + 40 + 20 * (i / 6), ((IParticleTimelineType)entry.getValue()).getSpellPart(), button -> {
                this.selectedTimeline = (IParticleTimelineType)entry.getValue();
                this.rowOffset = 0;
                LAST_SELECTED_PART = this.selectedTimeline;
                AbstractSpellPart spellPart = this.selectedTimeline.getSpellPart();
                this.timelineButton.title = Component.translatable((String)spellPart.getLocaleName());
                this.timelineButton.renderStack = spellPart.glyphItem.getDefaultInstance();
                this.clearList(this.propWidgetList.allButtons);
                this.propWidgetList.resetSelected();
                this.initLeftSideButtons();
            });
            this.rightPageWidgets.add((AbstractWidget)widget);
            this.addRenderableWidget((GuiEventListener)widget);
        }
    }

    private void clearRightPage() {
        this.clearList(this.rightPageWidgets);
        this.propertyWidgetProvider = null;
    }

    private void clearList(List<? extends AbstractWidget> list) {
        for (AbstractWidget abstractWidget : list) {
            this.removeWidget((GuiEventListener)abstractWidget);
        }
        list.clear();
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        DocClientUtils.drawHeader((Component)Component.translatable((String)"ars_nouveau.spell_styles"), graphics, this.bookLeft + 19, this.bookTop + 17, 118, mouseX, mouseY, partialTicks);
        if (this.propertyWidgetProvider != null) {
            this.propertyWidgetProvider.render(graphics, mouseX, mouseY, partialTicks);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    public void drawBackgroundElements(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackgroundElements(graphics, mouseX, mouseY, partialTicks);
        if (this.propertyWidgetProvider != null) {
            this.propertyWidgetProvider.renderBg(graphics, mouseX, mouseY, partialTicks);
        }
    }

    public void tick() {
        super.tick();
        if (this.propertyWidgetProvider != null) {
            this.propertyWidgetProvider.tick();
        }
    }

    public void addRightPageWidget(AbstractWidget widget) {
        this.rightPageWidgets.add(widget);
        this.addRenderableWidget((GuiEventListener)widget);
    }
}

