/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.entity;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.item.ICosmeticItem;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarWixie;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class WixieModel<T extends LivingEntity>
extends GeoModel<T> {
    private static final ResourceLocation WILD_TEXTURE = ArsNouveau.prefix("textures/entity/wixie.png");

    public void setCustomAnimations(T entity, long uniqueID, @Nullable AnimationState<T> customPredicate) {
        super.setCustomAnimations(entity, uniqueID, customPredicate);
        GeoBone head = this.getAnimationProcessor().getBone("head");
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraData().get(DataTickets.ENTITY_MODEL_DATA);
        head.setRotX(extraData.headPitch() * 0.010453292f);
        head.setRotY(extraData.netHeadYaw() * 0.015453292f);
        if (entity instanceof FamiliarWixie) {
            ICosmeticItem cosmetic;
            Item item;
            FamiliarWixie w = (FamiliarWixie)entity;
            this.getAnimationProcessor().getBone("hat").setHidden((item = w.getCosmeticItem().getItem()) instanceof ICosmeticItem && (cosmetic = (ICosmeticItem)item).getBone((LivingEntity)w).equals("hat"));
        }
    }

    public ResourceLocation getModelResource(T entityWixie) {
        return ArsNouveau.prefix("geo/wixie.geo.json");
    }

    public ResourceLocation getTextureResource(T entityWixie) {
        return WILD_TEXTURE;
    }

    public ResourceLocation getAnimationResource(T entityWixie) {
        return ArsNouveau.prefix("animations/wixie_animations.json");
    }
}

