/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.tile;

import com.hollingsworth.arsnouveau.common.block.tile.MirrorWeaveTile;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.BitSet;
import java.util.List;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.model.data.ModelData;

public class MirrorweaveRenderer<T extends MirrorWeaveTile>
implements BlockEntityRenderer<T> {
    static final Direction[] DIRECTIONS = Direction.values();

    public MirrorweaveRenderer(BlockEntityRendererProvider.Context pContext) {
    }

    public void render(MirrorWeaveTile tileEntityIn, float partialTick, PoseStack pPoseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BlockState renderState = tileEntityIn.mimicState;
        if (Minecraft.getInstance().player != null && Minecraft.getInstance().player.hasEffect(ModPotions.MAGIC_FIND_EFFECT)) {
            renderState = tileEntityIn.getDefaultBlockState();
        }
        if (renderState == null) {
            return;
        }
        if (tileEntityIn.renderInvalid) {
            this.updateCulling(tileEntityIn);
        }
        if (tileEntityIn.disableRender) {
            return;
        }
        ModelBlockRenderer.enableCaching();
        pPoseStack.pushPose();
        this.renderBlock(tileEntityIn, tileEntityIn.getBlockPos(), renderState, pPoseStack, bufferIn, tileEntityIn.getLevel(), true, combinedOverlayIn);
        pPoseStack.popPose();
        ModelBlockRenderer.clearCache();
    }

    public void updateCulling(MirrorWeaveTile tileEntityIn) {
        boolean disableEntireRender = true;
        tileEntityIn.renderInvalid = false;
        for (Direction direction : DIRECTIONS) {
            BlockPos blockingPos = tileEntityIn.getBlockPos().relative(direction);
            BlockState blockingState = tileEntityIn.getLevel().getBlockState(blockingPos);
            tileEntityIn.setRenderDirection(direction, false);
            BlockEntity blockEntity = tileEntityIn.getLevel().getBlockEntity(blockingPos);
            if (blockEntity instanceof MirrorWeaveTile) {
                MirrorWeaveTile neighborTile = (MirrorWeaveTile)blockEntity;
                blockingState = neighborTile.getStateForCulling();
            }
            VoxelShape blockingShape = blockingState.getOcclusionShape((BlockGetter)tileEntityIn.getLevel(), blockingPos);
            if (!tileEntityIn.shouldRenderFace(blockingState, tileEntityIn.getLevel(), tileEntityIn.getBlockPos(), direction, blockingPos)) continue;
            if (!blockingState.canOcclude()) {
                tileEntityIn.setRenderDirection(direction, true);
                disableEntireRender = false;
                continue;
            }
            if (!blockingState.canOcclude() || Shapes.blockOccudes((VoxelShape)Shapes.block(), (VoxelShape)blockingShape, (Direction)direction)) continue;
            tileEntityIn.setRenderDirection(direction, true);
            disableEntireRender = false;
        }
        tileEntityIn.disableRender = disableEntireRender;
    }

    private void renderBlock(MirrorWeaveTile tile, BlockPos pPos, BlockState pState, PoseStack pPoseStack, MultiBufferSource pBufferSource, Level pLevel, boolean pExtended, int pPackedOverlay) {
        this.renderPistonMovedBlocks(tile, pPos, pState, pPoseStack, pBufferSource, pLevel, pExtended, pPackedOverlay, Minecraft.getInstance().getBlockRenderer());
    }

    public void renderPistonMovedBlocks(MirrorWeaveTile tile, BlockPos pos, BlockState state, PoseStack stack, MultiBufferSource bufferSource, Level level, boolean checkSides, int packedOverlay, BlockRenderDispatcher blockRenderer) {
        BakedModel model = blockRenderer.getBlockModel(state);
        for (RenderType renderType : model.getRenderTypes(state, RandomSource.create((long)state.getSeed(pos)), ModelData.EMPTY)) {
            VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderTypeHelper.getMovingBlockRenderType((RenderType)renderType));
            this.tesselateBlock(tile, blockRenderer.getModelRenderer(), (BlockAndTintGetter)level, model, state, pos, stack, vertexConsumer, checkSides, RandomSource.create(), state.getSeed(pos), packedOverlay, ModelData.EMPTY, renderType);
        }
    }

    public void tesselateBlock(MirrorWeaveTile tile, ModelBlockRenderer blockRenderer, BlockAndTintGetter level, BakedModel model, BlockState state, BlockPos pos, PoseStack poseStack, VertexConsumer consumer, boolean checkSides, RandomSource random, long seed, int packedOverlay, ModelData modelData, RenderType renderType) {
        boolean bl;
        block11: {
            block10: {
                if (!Minecraft.useAmbientOcclusion()) break block10;
                switch (model.useAmbientOcclusion(state, modelData, renderType)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case TRUE: {
                        break;
                    }
                    case DEFAULT: {
                        if (state.getLightEmission((BlockGetter)level, pos) == 0) {
                            break;
                        }
                        break block10;
                    }
                    case FALSE: {
                        break block10;
                    }
                }
                bl = true;
                break block11;
            }
            bl = false;
        }
        boolean flag = bl;
        Vec3 vec3 = state.getOffset((BlockGetter)level, pos);
        poseStack.translate(vec3.x, vec3.y, vec3.z);
        try {
            if (flag) {
                this.tesselateWithAO(tile, blockRenderer, level, model, state, pos, poseStack, consumer, checkSides, random, seed, packedOverlay, modelData, renderType);
            } else {
                this.tesselateWithoutAO(tile, blockRenderer, level, model, state, pos, poseStack, consumer, checkSides, random, seed, packedOverlay, modelData, renderType);
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable, (String)"Tesselating block model");
            CrashReportCategory crashreportcategory = crashreport.addCategory("Block model being tesselated");
            CrashReportCategory.populateBlockDetails((CrashReportCategory)crashreportcategory, (LevelHeightAccessor)level, (BlockPos)pos, (BlockState)state);
            crashreportcategory.setDetail("Using AO", (Object)flag);
            throw new ReportedException(crashreport);
        }
    }

    public void tesselateWithoutAO(MirrorWeaveTile tile, ModelBlockRenderer renderer, BlockAndTintGetter level, BakedModel model, BlockState state, BlockPos pos, PoseStack poseStack, VertexConsumer consumer, boolean checkSides, RandomSource random, long seed, int packedOverlay, ModelData modelData, RenderType renderType) {
        BitSet bitset = new BitSet(3);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.mutable();
        for (Direction direction : DIRECTIONS) {
            if (checkSides && !tile.shouldRenderDirection(direction)) continue;
            random.setSeed(seed);
            List list = model.getQuads(state, direction, random, modelData, renderType);
            if (list.isEmpty()) continue;
            blockpos$mutableblockpos.setWithOffset((Vec3i)pos, direction);
            int i = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockState)state, (BlockPos)blockpos$mutableblockpos);
            this.renderModelFaceFlat(renderer, level, state, pos, i, packedOverlay, false, poseStack, consumer, list, bitset);
        }
        random.setSeed(seed);
        List list1 = model.getQuads(state, null, random, modelData, renderType);
        if (!list1.isEmpty()) {
            this.renderModelFaceFlat(renderer, level, state, pos, -1, packedOverlay, true, poseStack, consumer, list1, bitset);
        }
    }

    private void renderModelFaceFlat(ModelBlockRenderer renderer, BlockAndTintGetter level, BlockState state, BlockPos pos, int packedLight, int packedOverlay, boolean repackLight, PoseStack poseStack, VertexConsumer consumer, List<BakedQuad> quads, BitSet shapeFlags) {
        for (BakedQuad bakedquad : quads) {
            if (repackLight) {
                renderer.calculateShape(level, state, pos, bakedquad.getVertices(), bakedquad.getDirection(), null, shapeFlags);
                BlockPos blockpos = shapeFlags.get(0) ? pos.relative(bakedquad.getDirection()) : pos;
                packedLight = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockState)state, (BlockPos)blockpos);
            }
            float f = level.getShade(bakedquad.getDirection(), bakedquad.isShade());
            renderer.putQuadData(level, state, pos, consumer, poseStack.last(), bakedquad, f, f, f, f, packedLight, packedLight, packedLight, packedLight, packedOverlay);
        }
    }

    public void tesselateWithAO(MirrorWeaveTile tile, ModelBlockRenderer blockRenderer, BlockAndTintGetter level, BakedModel model, BlockState state, BlockPos pos, PoseStack poseStack, VertexConsumer consumer, boolean checkSides, RandomSource random, long seed, int packedOverlay, ModelData modelData, RenderType renderType) {
        float[] afloat = new float[DIRECTIONS.length * 2];
        BitSet bitset = new BitSet(3);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.mutable();
        for (Direction direction : DIRECTIONS) {
            if (checkSides && !tile.shouldRenderDirection(direction)) continue;
            random.setSeed(seed);
            List list = model.getQuads(state, direction, random, modelData, renderType);
            if (list.isEmpty()) continue;
            blockpos$mutableblockpos.setWithOffset((Vec3i)pos, direction);
            this.renderModelFaceAO(blockRenderer, level, state, pos, poseStack, consumer, list, afloat, bitset, packedOverlay);
        }
        random.setSeed(seed);
        List list1 = model.getQuads(state, null, random, modelData, renderType);
        if (!list1.isEmpty()) {
            this.renderModelFaceAO(blockRenderer, level, state, pos, poseStack, consumer, list1, afloat, bitset, packedOverlay);
        }
    }

    private void renderModelFaceAO(ModelBlockRenderer blockRenderer, BlockAndTintGetter level, BlockState state, BlockPos pos, PoseStack poseStack, VertexConsumer consumer, List<BakedQuad> quads, float[] shape, BitSet shapeFlags, int packedOverlay) {
        ModelBlockRenderer.AmbientOcclusionFace aoFace = new ModelBlockRenderer.AmbientOcclusionFace();
        for (BakedQuad bakedquad : quads) {
            blockRenderer.calculateShape(level, state, pos, bakedquad.getVertices(), bakedquad.getDirection(), shape, shapeFlags);
            if (!ClientHooks.calculateFaceWithoutAO((BlockAndTintGetter)level, (BlockState)state, (BlockPos)pos, (BakedQuad)bakedquad, (boolean)shapeFlags.get(0), (float[])aoFace.brightness, (int[])aoFace.lightmap)) {
                aoFace.calculate(level, state, pos, bakedquad.getDirection(), shape, shapeFlags, bakedquad.isShade());
            }
            blockRenderer.putQuadData(level, state, pos, consumer, poseStack.last(), bakedquad, aoFace.brightness[0], aoFace.brightness[1], aoFace.brightness[2], aoFace.brightness[3], aoFace.lightmap[0], aoFace.lightmap[1], aoFace.lightmap[2], aoFace.lightmap[3], packedOverlay);
        }
    }

    public int getViewDistance() {
        return 68;
    }
}

