/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.api.documentation.DocCategory;
import com.hollingsworth.arsnouveau.api.registry.DocumentationRegistry;
import com.hollingsworth.arsnouveau.common.datagen.SimpleDataProvider;
import com.hollingsworth.arsnouveau.setup.registry.Documentation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;

public class DocProvider
extends SimpleDataProvider {
    public CompletableFuture<HolderLookup.Provider> registries;
    List<DocCategory> categories = new ArrayList<DocCategory>();

    public DocProvider(DataGenerator generatorIn, CompletableFuture<HolderLookup.Provider> registries) {
        super(generatorIn);
        this.registries = registries;
    }

    @Override
    public void collectJsons(CachedOutput pOutput) {
        Documentation.initOnWorldReload();
        for (DocCategory category : DocumentationRegistry.getMainCategoryMap().values()) {
            if (!category.id().getNamespace().equals("ars_nouveau")) continue;
            this.categories.add(category);
        }
        for (DocCategory category : this.categories) {
            this.saveStable(pOutput, (JsonElement)category.toJson(), this.output.resolve("data/" + category.id().getNamespace() + "/doc/" + category.id().getPath() + ".json"));
        }
    }

    public String getName() {
        return "Doc provider";
    }
}

