/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;

public class UntamedFindItemGoal
extends Goal {
    Mob mobEntity;
    Predicate<ItemEntity> itemSelector;
    Supplier<Boolean> canRun;
    int timeFinding;
    boolean itemStuck;
    ItemEntity pathingEntity;

    public List<ItemEntity> nearbyItems() {
        return this.mobEntity.level.getEntitiesOfClass(ItemEntity.class, new AABB(this.mobEntity.blockPosition()).inflate(8.0), this.itemSelector);
    }

    public UntamedFindItemGoal(Mob mobEntity, Supplier<Boolean> canRun, Predicate<ItemEntity> itemSelector) {
        this.mobEntity = mobEntity;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        this.canRun = canRun;
        this.itemSelector = itemSelector;
    }

    public void tick() {
        super.tick();
        ++this.timeFinding;
        if (this.pathingEntity == null || this.pathingEntity.isRemoved()) {
            return;
        }
        this.pathToTarget((Entity)this.pathingEntity, 1.2f);
    }

    public boolean canContinueToUse() {
        return this.timeFinding <= 600 && !this.itemStuck && this.pathingEntity != null && !this.pathingEntity.isRemoved() && !this.pathingEntity.getItem().isEmpty() && this.canUse();
    }

    public boolean canUse() {
        return this.canRun.get() != false && !this.nearbyItems().isEmpty();
    }

    public void stop() {
        super.stop();
        this.timeFinding = 0;
        this.itemStuck = false;
    }

    public void start() {
        super.start();
        this.timeFinding = 0;
        this.itemStuck = false;
        List<ItemEntity> list = this.nearbyItems();
        if (!list.isEmpty() && !this.itemStuck) {
            for (ItemEntity item : list) {
                Path path = this.mobEntity.getNavigation().createPath((Entity)item, 0);
                if (path == null || !path.canReach()) continue;
                this.pathingEntity = item;
                this.pathToTarget((Entity)this.pathingEntity, 1.2f);
                break;
            }
        }
        if (this.pathingEntity == null) {
            this.itemStuck = true;
        }
    }

    public void pathToTarget(Entity entity, double speed) {
        Path path = this.mobEntity.getNavigation().createPath(entity, 0);
        if (path != null && path.canReach()) {
            this.mobEntity.getNavigation().moveTo(path, speed);
        }
        if (path != null && !path.canReach()) {
            this.itemStuck = true;
        }
    }
}

