/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.block.tile.PlanariumTile;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateDimTile;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class PacketClientRequestDim
extends AbstractPacket {
    public static final CustomPacketPayload.Type<PacketClientRequestDim> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("request_planarium"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketClientRequestDim> CODEC = StreamCodec.ofMember(PacketClientRequestDim::toBytes, PacketClientRequestDim::new);
    public BlockPos pos;

    public PacketClientRequestDim(BlockPos pos) {
        this.pos = pos;
    }

    public PacketClientRequestDim(RegistryFriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        super.onServerReceived(minecraftServer, player);
        BlockEntity blockEntity = player.level.getBlockEntity(this.pos);
        if (blockEntity instanceof PlanariumTile) {
            StructureTemplate template;
            PlanariumTile planariumTile = (PlanariumTile)blockEntity;
            if (planariumTile.key != null && (template = PlanariumTile.dimManager.getTemplate(planariumTile.key)) != null) {
                Networking.sendToPlayerClient(new PacketUpdateDimTile(this.pos, template), player);
            }
        }
    }
}

