/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.ritual;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.ritual.FeaturePlacementRitual;
import com.hollingsworth.arsnouveau.api.ritual.features.BigTreeFeature;
import com.hollingsworth.arsnouveau.api.ritual.features.BonemealFeature;
import com.hollingsworth.arsnouveau.api.ritual.features.CocoaFeature;
import com.hollingsworth.arsnouveau.api.ritual.features.ConvertBlockFeature;
import com.hollingsworth.arsnouveau.api.ritual.features.IPlaceableFeature;
import com.hollingsworth.arsnouveau.api.ritual.features.PlaceBlockFeature;
import com.hollingsworth.arsnouveau.api.ritual.features.RandomTreeFeature;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.lib.RitualLib;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import oshi.util.tuples.Pair;

public class ForestationRitual
extends FeaturePlacementRitual {
    @Override
    public void addFeatures(List<IPlaceableFeature> features) {
        boolean isTaiga = this.getConsumedItems().stream().anyMatch(i -> i.getItem() == Items.BROWN_MUSHROOM);
        boolean isJungle = this.getConsumedItems().stream().anyMatch(i -> i.getItem() == Items.GLOW_BERRIES);
        if (isTaiga) {
            features.add(new RandomTreeFeature(List.of(Blocks.SPRUCE_SAPLING.defaultBlockState()), 8.0, 0.8));
            features.add(new ConvertBlockFeature(0.0, 0.8, state -> state.is(BlockTags.DIRT) || state.getBlock() == Blocks.GRASS_BLOCK, state -> Blocks.PODZOL.defaultBlockState(), (Pair<BlockPos, BlockPos>)new Pair((Object)new BlockPos(0, -1, 0), (Object)BlockPos.ZERO)));
            features.add(new PlaceBlockFeature(0.0, 0.1, () -> (double)this.getWorld().random.nextFloat() < 0.3 ? Blocks.LARGE_FERN.defaultBlockState() : Blocks.FERN.defaultBlockState()));
            features.add(new PlaceBlockFeature(0.0, 0.1, () -> ((Block)Blocks.BROWN_MUSHROOM).defaultBlockState()));
            features.add(new PlaceBlockFeature(0.0, 0.1, () -> ((Block)Blocks.GRASS_BLOCK).defaultBlockState()));
            features.add(new PlaceBlockFeature(0.0, 0.01, () -> (BlockState)Blocks.SWEET_BERRY_BUSH.defaultBlockState().setValue((Property)SweetBerryBushBlock.AGE, (Comparable)Integer.valueOf(this.getWorld().random.nextInt(4)))));
        } else if (isJungle) {
            features.add(new BigTreeFeature(Blocks.JUNGLE_SAPLING.defaultBlockState(), 12.0, 0.3));
            features.add(new RandomTreeFeature(List.of(Blocks.JUNGLE_SAPLING.defaultBlockState()), 6.0, 0.95));
            features.add(new CocoaFeature(6.0, 0.4));
            features.add(new PlaceBlockFeature(0.0, 0.1, () -> ((Block)Blocks.GRASS_BLOCK).defaultBlockState()));
            features.add(new PlaceBlockFeature(0.0, 0.01, () -> ((Block)Blocks.MELON).defaultBlockState()));
            features.add(new PlaceBlockFeature(0.0, 0.1, () -> ((Block)Blocks.FERN).defaultBlockState()));
        } else {
            features.add(new RandomTreeFeature(List.of(Blocks.OAK_SAPLING.defaultBlockState(), Blocks.BIRCH_SAPLING.defaultBlockState()), 5.0, 0.8));
            features.add(new BonemealFeature(6.0, 0.8));
        }
    }

    @Override
    public ResourceLocation getRegistryName() {
        return ArsNouveau.prefix(RitualLib.FORESTATION);
    }

    @Override
    public boolean canConsumeItem(ItemStack stack) {
        boolean isTaiga = this.getConsumedItems().stream().anyMatch(i -> i.getItem() == Items.BROWN_MUSHROOM);
        boolean isJungle = this.getConsumedItems().stream().anyMatch(i -> i.getItem() == Items.GLOW_BERRIES);
        boolean isVariant = isTaiga || isJungle;
        return super.canConsumeItem(stack) || stack.getItem() == Items.BROWN_MUSHROOM && !isVariant || stack.getItem() == Items.GLOW_BERRIES && !isVariant;
    }

    @Override
    public String getLangName() {
        return "Forestation";
    }

    @Override
    public String getLangDescription() {
        return "Places grown Oak and Birch trees, and applies bonemeal in a 7x7 (circular) area. Augmenting with a source gem will increase the radius by 1 for each gem. Augmenting with a Brown Mushroom will convert the area to Podzol and spawn taiga resources. Augmenting with Glow Berries will spawn jungle resources.";
    }

    @Override
    public ParticleColor getCenterColor() {
        return new ParticleColor(0, 255, 0);
    }
}

