/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.search;

import java.io.IOException;
import org.apache.lucene.ars_nouveau.index.LeafReaderContext;
import org.apache.lucene.ars_nouveau.search.Explanation;
import org.apache.lucene.ars_nouveau.search.Query;
import org.apache.lucene.ars_nouveau.search.Scorer;
import org.apache.lucene.ars_nouveau.search.TwoPhaseIterator;
import org.apache.lucene.ars_nouveau.search.Weight;

public abstract class ConstantScoreWeight
extends Weight {
    private final float score;

    protected ConstantScoreWeight(Query query, float score) {
        super(query);
        this.score = score;
    }

    protected final float score() {
        return this.score;
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        boolean exists;
        Scorer s = this.scorer(context);
        if (s == null) {
            exists = false;
        } else {
            TwoPhaseIterator twoPhase = s.twoPhaseIterator();
            if (twoPhase == null) {
                exists = s.iterator().advance(doc) == doc;
            } else {
                boolean bl = exists = twoPhase.approximation().advance(doc) == doc && twoPhase.matches();
            }
        }
        if (exists) {
            return Explanation.match((Number)Float.valueOf(this.score), this.getQuery().toString() + (String)(this.score == 1.0f ? "" : "^" + this.score), new Explanation[0]);
        }
        return Explanation.noMatch(this.getQuery().toString() + " doesn't match id " + doc, new Explanation[0]);
    }
}

