/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.lucene.ars_nouveau.search.DisiPriorityQueue;
import org.apache.lucene.ars_nouveau.search.DisiWrapper;
import org.apache.lucene.ars_nouveau.search.DocIdSetIterator;
import org.apache.lucene.ars_nouveau.search.Scorable;
import org.apache.lucene.ars_nouveau.search.ScoreMode;
import org.apache.lucene.ars_nouveau.search.Scorer;
import org.apache.lucene.ars_nouveau.search.ScorerUtil;
import org.apache.lucene.ars_nouveau.search.TwoPhaseIterator;
import org.apache.lucene.ars_nouveau.util.MathUtil;

final class WANDScorer
extends Scorer {
    static final int FLOAT_MANTISSA_BITS = 24;
    private static final long MAX_SCALED_SCORE = 0xFFFFFFL;
    private final int scalingFactor;
    private long minCompetitiveScore;
    private final Scorer[] allScorers;
    DisiWrapper lead;
    int doc;
    double leadScore;
    final DisiPriorityQueue head;
    final DisiWrapper[] tail;
    long tailMaxScore;
    int tailSize;
    final long cost;
    int upTo;
    final int minShouldMatch;
    int freq;
    final ScoreMode scoreMode;
    final long leadCost;

    static int scalingFactor(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("Scores must be positive or null");
        }
        if (f == 0.0f) {
            return WANDScorer.scalingFactor(Float.MIN_VALUE) + 1;
        }
        if (Float.isInfinite(f)) {
            return WANDScorer.scalingFactor(Float.MAX_VALUE) - 1;
        }
        double d = f;
        assert (d == 0.0 || Math.getExponent(d) >= -1022);
        return 23 - Math.getExponent(d);
    }

    static long scaleMaxScore(float maxScore, int scalingFactor) {
        assert (!Float.isNaN(maxScore));
        assert (maxScore >= 0.0f);
        double scaled = Math.scalb((double)maxScore, scalingFactor);
        if (scaled > 1.6777215E7) {
            return 0xFFFFFFL;
        }
        return (long)Math.ceil(scaled);
    }

    private static long scaleMinScore(float minScore, int scalingFactor) {
        assert (Float.isFinite(minScore));
        assert (minScore >= 0.0f);
        double scaled = Math.scalb((double)minScore, scalingFactor);
        return (long)Math.floor(scaled);
    }

    WANDScorer(Collection<Scorer> scorers, int minShouldMatch, ScoreMode scoreMode, long leadCost) throws IOException {
        if (minShouldMatch >= scorers.size()) {
            throw new IllegalArgumentException("minShouldMatch should be < the number of scorers");
        }
        this.allScorers = (Scorer[])scorers.toArray(Scorer[]::new);
        this.minCompetitiveScore = 0L;
        assert (minShouldMatch >= 0) : "minShouldMatch should not be negative, but got " + minShouldMatch;
        this.minShouldMatch = minShouldMatch;
        this.doc = -1;
        this.upTo = -1;
        this.scoreMode = scoreMode;
        this.head = new DisiPriorityQueue(scorers.size());
        this.tail = new DisiWrapper[scorers.size()];
        if (this.scoreMode == ScoreMode.TOP_SCORES) {
            double maxScoreSumDouble = 0.0;
            for (Scorer scorer : scorers) {
                scorer.advanceShallow(0);
                float maxScore = scorer.getMaxScore(Integer.MAX_VALUE);
                maxScoreSumDouble += (double)maxScore;
            }
            float maxScoreSum = (float)MathUtil.sumUpperBound(maxScoreSumDouble, scorers.size());
            this.scalingFactor = WANDScorer.scalingFactor(maxScoreSum);
        } else {
            this.scalingFactor = 0;
        }
        for (Scorer scorer : scorers) {
            this.addUnpositionedLead(new DisiWrapper(scorer, true));
        }
        this.cost = ScorerUtil.costWithMinShouldMatch(scorers.stream().map(Scorer::iterator).mapToLong(DocIdSetIterator::cost), scorers.size(), minShouldMatch);
        this.leadCost = leadCost;
    }

    private boolean ensureConsistent() throws IOException {
        if (this.scoreMode == ScoreMode.TOP_SCORES) {
            long maxScoreSum = 0L;
            for (int i = 0; i < this.tailSize; ++i) {
                assert (this.tail[i].doc < this.doc);
                maxScoreSum = Math.addExact(maxScoreSum, this.tail[i].scaledMaxScore);
            }
            assert (maxScoreSum == this.tailMaxScore) : maxScoreSum + " " + this.tailMaxScore;
            ArrayList<Float> leadScores = new ArrayList<Float>();
            DisiWrapper w = this.lead;
            while (w != null) {
                assert (w.doc == this.doc);
                leadScores.add(Float.valueOf(w.scorable.score()));
                w = w.next;
            }
            Collections.reverse(leadScores);
            double recomputedLeadScore = 0.0;
            Iterator iterator = leadScores.iterator();
            while (iterator.hasNext()) {
                float score = ((Float)iterator.next()).floatValue();
                recomputedLeadScore += (double)score;
            }
            assert (recomputedLeadScore == this.leadScore);
            assert (this.minCompetitiveScore == 0L || this.tailMaxScore < this.minCompetitiveScore || this.tailSize < this.minShouldMatch);
            assert (this.doc <= this.upTo);
        }
        for (DisiWrapper w : this.head) {
            if (this.lead == null ? !$assertionsDisabled && w.doc < this.doc : !$assertionsDisabled && w.doc <= this.doc) {
                throw new AssertionError();
            }
        }
        return true;
    }

    @Override
    public void setMinCompetitiveScore(float minScore) throws IOException {
        assert (this.scoreMode == ScoreMode.TOP_SCORES) : "minCompetitiveScore can only be set for ScoreMode.TOP_SCORES, but got: " + String.valueOf((Object)this.scoreMode);
        assert (minScore >= 0.0f);
        long scaledMinScore = WANDScorer.scaleMinScore(minScore, this.scalingFactor);
        assert (scaledMinScore >= this.minCompetitiveScore);
        this.minCompetitiveScore = scaledMinScore;
    }

    @Override
    public final Collection<Scorable.ChildScorable> getChildren() throws IOException {
        ArrayList<Scorable.ChildScorable> matchingChildren = new ArrayList<Scorable.ChildScorable>();
        this.advanceAllTail();
        DisiWrapper s = this.lead;
        while (s != null) {
            matchingChildren.add(new Scorable.ChildScorable(s.scorer, "SHOULD"));
            s = s.next;
        }
        return matchingChildren;
    }

    @Override
    public DocIdSetIterator iterator() {
        return TwoPhaseIterator.asDocIdSetIterator(this.twoPhaseIterator());
    }

    @Override
    public TwoPhaseIterator twoPhaseIterator() {
        DocIdSetIterator approximation = new DocIdSetIterator(){

            @Override
            public int docID() {
                return WANDScorer.this.doc;
            }

            @Override
            public int nextDoc() throws IOException {
                return this.advance(WANDScorer.this.doc + 1);
            }

            @Override
            public int advance(int target) throws IOException {
                WANDScorer.this.pushBackLeads(target);
                DisiWrapper headTop = WANDScorer.this.advanceHead(target);
                if (WANDScorer.this.scoreMode == ScoreMode.TOP_SCORES && (headTop == null || headTop.doc > WANDScorer.this.upTo)) {
                    WANDScorer.this.moveToNextBlock(target);
                    assert (WANDScorer.this.upTo >= target);
                    headTop = WANDScorer.this.head.top();
                }
                if (headTop == null) {
                    WANDScorer.this.doc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                WANDScorer.this.doc = headTop.doc;
                return WANDScorer.this.doc;
            }

            @Override
            public long cost() {
                return WANDScorer.this.cost;
            }
        };
        return new TwoPhaseIterator(approximation){

            @Override
            public boolean matches() throws IOException {
                assert (WANDScorer.this.lead == null);
                WANDScorer.this.moveToNextCandidate();
                long scaledLeadScore = 0L;
                if (WANDScorer.this.scoreMode == ScoreMode.TOP_SCORES) {
                    scaledLeadScore = WANDScorer.scaleMaxScore((float)MathUtil.sumUpperBound(WANDScorer.this.leadScore, 24), WANDScorer.this.scalingFactor);
                }
                while (scaledLeadScore < WANDScorer.this.minCompetitiveScore || WANDScorer.this.freq < WANDScorer.this.minShouldMatch) {
                    assert (WANDScorer.this.ensureConsistent());
                    if (scaledLeadScore + WANDScorer.this.tailMaxScore < WANDScorer.this.minCompetitiveScore || WANDScorer.this.freq + WANDScorer.this.tailSize < WANDScorer.this.minShouldMatch) {
                        return false;
                    }
                    DisiWrapper prevLead = WANDScorer.this.lead;
                    WANDScorer.this.advanceTail();
                    if (WANDScorer.this.scoreMode != ScoreMode.TOP_SCORES || WANDScorer.this.lead == prevLead) continue;
                    assert (prevLead == WANDScorer.this.lead.next);
                    scaledLeadScore = WANDScorer.scaleMaxScore((float)MathUtil.sumUpperBound(WANDScorer.this.leadScore, 24), WANDScorer.this.scalingFactor);
                }
                assert (WANDScorer.this.ensureConsistent());
                return true;
            }

            @Override
            public float matchCost() {
                return WANDScorer.this.tail.length;
            }
        };
    }

    private void addLead(DisiWrapper lead) throws IOException {
        lead.next = this.lead;
        this.lead = lead;
        ++this.freq;
        if (this.scoreMode == ScoreMode.TOP_SCORES) {
            this.leadScore += (double)lead.scorable.score();
        }
    }

    private void addUnpositionedLead(DisiWrapper lead) {
        assert (lead.doc == -1);
        lead.next = this.lead;
        this.lead = lead;
        ++this.freq;
    }

    private void pushBackLeads(int target) throws IOException {
        DisiWrapper s = this.lead;
        while (s != null) {
            DisiWrapper evicted = this.insertTailWithOverFlow(s);
            if (evicted != null) {
                evicted.doc = evicted.iterator.advance(target);
                this.head.add(evicted);
            }
            s = s.next;
        }
        this.lead = null;
    }

    private DisiWrapper advanceHead(int target) throws IOException {
        DisiWrapper headTop = this.head.top();
        while (headTop != null && headTop.doc < target) {
            DisiWrapper evicted = this.insertTailWithOverFlow(headTop);
            if (evicted != null) {
                evicted.doc = evicted.iterator.advance(target);
                headTop = this.head.updateTop(evicted);
                continue;
            }
            this.head.pop();
            headTop = this.head.top();
        }
        return headTop;
    }

    private void advanceTail(DisiWrapper disi) throws IOException {
        disi.doc = disi.iterator.advance(this.doc);
        if (disi.doc == this.doc) {
            this.addLead(disi);
        } else {
            this.head.add(disi);
        }
    }

    private void advanceTail() throws IOException {
        DisiWrapper top = this.popTail();
        this.advanceTail(top);
    }

    private void updateMaxScores(int target) throws IOException {
        int newUpTo = Integer.MAX_VALUE;
        for (DisiWrapper w : this.head) {
            if (w.doc > newUpTo || w.cost > this.leadCost) continue;
            newUpTo = Math.min(w.scorer.advanceShallow(w.doc), newUpTo);
        }
        if (newUpTo == Integer.MAX_VALUE && this.tailSize > 0 && this.tail[0].cost <= this.leadCost) {
            newUpTo = this.tail[0].scorer.advanceShallow(target);
            DisiWrapper headTop = this.head.top();
            if (headTop != null) {
                newUpTo = Math.max(newUpTo, headTop.doc);
            }
        }
        this.upTo = newUpTo;
        for (DisiWrapper w : this.head) {
            if (w.doc > this.upTo) continue;
            w.scaledMaxScore = WANDScorer.scaleMaxScore(w.scorer.getMaxScore(newUpTo), this.scalingFactor);
        }
        this.tailMaxScore = 0L;
        for (int i = 0; i < this.tailSize; ++i) {
            DisiWrapper w;
            w = this.tail[i];
            w.scorer.advanceShallow(target);
            w.scaledMaxScore = WANDScorer.scaleMaxScore(w.scorer.getMaxScore(this.upTo), this.scalingFactor);
            WANDScorer.upHeapMaxScore(this.tail, i);
            this.tailMaxScore += w.scaledMaxScore;
        }
        while (this.tailSize > 0 && this.tailMaxScore >= this.minCompetitiveScore) {
            DisiWrapper w = this.popTail();
            w.doc = w.iterator.advance(target);
            this.head.add(w);
        }
    }

    private void moveToNextBlock(int target) throws IOException {
        assert (this.lead == null);
        while (this.upTo < Integer.MAX_VALUE) {
            if (this.head.size() == 0) {
                target = Math.max(target, this.upTo + 1);
                this.updateMaxScores(target);
                continue;
            }
            if (this.head.top().doc <= this.upTo) break;
            assert (this.head.top().doc >= target);
            this.updateMaxScores(target);
            break;
        }
        assert (this.head.size() == 0 || this.head.top().doc <= this.upTo);
        assert (this.upTo >= target);
    }

    private void moveToNextCandidate() throws IOException {
        this.lead = this.head.pop();
        assert (this.doc == this.lead.doc);
        this.lead.next = null;
        this.freq = 1;
        if (this.scoreMode == ScoreMode.TOP_SCORES) {
            this.leadScore = this.lead.scorable.score();
        }
        while (this.head.size() > 0 && this.head.top().doc == this.doc) {
            this.addLead(this.head.pop());
        }
    }

    private void advanceAllTail() throws IOException {
        for (int i = this.tailSize - 1; i >= 0; --i) {
            this.advanceTail(this.tail[i]);
        }
        this.tailSize = 0;
        this.tailMaxScore = 0L;
        assert (this.ensureConsistent());
    }

    @Override
    public float score() throws IOException {
        this.advanceAllTail();
        double leadScore = this.leadScore;
        if (this.scoreMode != ScoreMode.TOP_SCORES) {
            DisiWrapper s = this.lead;
            while (s != null) {
                leadScore += (double)s.scorable.score();
                s = s.next;
            }
        }
        return (float)leadScore;
    }

    @Override
    public int advanceShallow(int target) throws IOException {
        for (Scorer scorer : this.allScorers) {
            if (scorer.docID() >= target) continue;
            scorer.advanceShallow(target);
        }
        if (target <= this.upTo) {
            return this.upTo;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        double maxScoreSum = 0.0;
        for (Scorer scorer : this.allScorers) {
            if (scorer.docID() > upTo) continue;
            maxScoreSum += (double)scorer.getMaxScore(upTo);
        }
        return (float)MathUtil.sumUpperBound(maxScoreSum, this.allScorers.length);
    }

    @Override
    public int docID() {
        return this.doc;
    }

    private DisiWrapper insertTailWithOverFlow(DisiWrapper s) {
        if (this.tailMaxScore + s.scaledMaxScore < this.minCompetitiveScore || this.tailSize + 1 < this.minShouldMatch) {
            this.addTail(s);
            this.tailMaxScore += s.scaledMaxScore;
            return null;
        }
        if (this.tailSize == 0) {
            return s;
        }
        DisiWrapper top = this.tail[0];
        if (!WANDScorer.greaterMaxScore(top, s)) {
            return s;
        }
        this.tail[0] = s;
        WANDScorer.downHeapMaxScore(this.tail, this.tailSize);
        this.tailMaxScore = this.tailMaxScore - top.scaledMaxScore + s.scaledMaxScore;
        return top;
    }

    private void addTail(DisiWrapper s) {
        this.tail[this.tailSize] = s;
        WANDScorer.upHeapMaxScore(this.tail, this.tailSize);
        ++this.tailSize;
    }

    private DisiWrapper popTail() {
        assert (this.tailSize > 0);
        DisiWrapper result = this.tail[0];
        this.tail[0] = this.tail[--this.tailSize];
        WANDScorer.downHeapMaxScore(this.tail, this.tailSize);
        this.tailMaxScore -= result.scaledMaxScore;
        return result;
    }

    private static void upHeapMaxScore(DisiWrapper[] heap, int i) {
        DisiWrapper node = heap[i];
        int j = DisiPriorityQueue.parentNode(i);
        while (j >= 0 && WANDScorer.greaterMaxScore(node, heap[j])) {
            heap[i] = heap[j];
            i = j;
            j = DisiPriorityQueue.parentNode(j);
        }
        heap[i] = node;
    }

    private static void downHeapMaxScore(DisiWrapper[] heap, int size) {
        int i = 0;
        DisiWrapper node = heap[0];
        int j = DisiPriorityQueue.leftNode(i);
        if (j < size) {
            int k = DisiPriorityQueue.rightNode(j);
            if (k < size && WANDScorer.greaterMaxScore(heap[k], heap[j])) {
                j = k;
            }
            if (WANDScorer.greaterMaxScore(heap[j], node)) {
                do {
                    heap[i] = heap[j];
                    i = j;
                    k = DisiPriorityQueue.rightNode(j = DisiPriorityQueue.leftNode(i));
                    if (k >= size || !WANDScorer.greaterMaxScore(heap[k], heap[j])) continue;
                    j = k;
                } while (j < size && WANDScorer.greaterMaxScore(heap[j], node));
                heap[i] = node;
            }
        }
    }

    private static boolean greaterMaxScore(DisiWrapper w1, DisiWrapper w2) {
        if (w1.scaledMaxScore > w2.scaledMaxScore) {
            return true;
        }
        if (w1.scaledMaxScore < w2.scaledMaxScore) {
            return false;
        }
        return w1.cost < w2.cost;
    }
}

