/*
 * Decompiled with CFR 0.152.
 */
package artifacts.mixin.item;

import artifacts.Artifacts;
import artifacts.equipment.EquipmentSlotManager;
import artifacts.registry.ModLootTables;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NaturalSpawner.class})
public class NaturalSpawnerMixin {
    @Inject(method={"spawnCategoryForPosition(Lnet/minecraft/world/entity/MobCategory;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/chunk/ChunkAccess;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/NaturalSpawner$SpawnPredicate;Lnet/minecraft/world/level/NaturalSpawner$AfterSpawnCallback;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;addFreshEntityWithPassengers(Lnet/minecraft/world/entity/Entity;)V", shift=At.Shift.AFTER)})
    private static void spawnCategoryForPosition(MobCategory mobCategory, ServerLevel serverLevel, ChunkAccess chunkAccess, BlockPos blockPos, NaturalSpawner.SpawnPredicate spawnPredicate, NaturalSpawner.AfterSpawnCallback afterSpawnCallback, CallbackInfo ci, @Local(ordinal=0) Mob mob) {
        Level level;
        if (ModLootTables.ENTITY_EQUIPMENT.containsKey(mob.getType()) && (level = mob.level()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            ResourceKey<LootTable> id = ModLootTables.ENTITY_EQUIPMENT.get(mob.getType());
            LootTable loottable = level2.getServer().reloadableRegistries().getLootTable(id);
            LootParams.Builder params = new LootParams.Builder(level2);
            LootParams lootparams = params.create(LootContextParamSets.EMPTY);
            loottable.getRandomItems(lootparams, mob.getLootTableSeed(), stack -> {
                if (!EquipmentSlotManager.tryEquipAccessory((LivingEntity)mob, stack)) {
                    Artifacts.LOGGER.warn("Could not equip item '{}' on spawned entity '{}'", stack, (Object)mob);
                }
            });
        }
    }
}

