/*
 * Decompiled with CFR 0.152.
 */
package artifacts.registry;

import artifacts.Artifacts;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class ModTags {
    public static final TagKey<Block> MINEABLE_WITH_DIGGING_CLAWS = ModTags.create(Registries.BLOCK, "mineable/digging_claws");
    public static final TagKey<Block> CAMPSITE_CHESTS = ModTags.create(Registries.BLOCK, "campsite_chests");
    public static final TagKey<Block> ROOTED_BOOTS_GRASS = ModTags.create(Registries.BLOCK, "rooted_boots_grass");
    public static final TagKey<Block> SNOW_LAYERS = ModTags.create(Registries.BLOCK, "snow_layers");
    public static final TagKey<MobEffect> ANTIDOTE_VESSEL_CANCELLABLE = ModTags.create(Registries.MOB_EFFECT, "antidote_vessel_cancellable");
    public static final TagKey<EntityType<?>> CREEPERS = ModTags.create(Registries.ENTITY_TYPE, "creepers");
    public static final TagKey<DamageType> IS_HOT_FLOOR = ModTags.create(Registries.DAMAGE_TYPE, "is_hot_floor");
    public static final TagKey<Block> ORES = ModTags.conventionTag(Registries.BLOCK, "ores");
    public static final TagKey<Item> RAW_MATERIALS = ModTags.conventionTag(Registries.ITEM, "raw_materials");

    private static <T> TagKey<T> create(ResourceKey<Registry<T>> registry, String name) {
        return TagKey.create(registry, (ResourceLocation)Artifacts.id(name));
    }

    private static <T> TagKey<T> conventionTag(ResourceKey<Registry<T>> registry, String name) {
        return TagKey.create(registry, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
    }

    public static <T> HolderSet<T> getTag(TagKey<T> tagKey) {
        Registry registry = (Registry)BuiltInRegistries.REGISTRY.get(tagKey.registry().location());
        return registry.getOrCreateTag(tagKey);
    }

    public static <T> boolean isInTag(T value, TagKey<T> tagKey) {
        Registry registry = (Registry)BuiltInRegistries.REGISTRY.get(tagKey.registry().location());
        return registry.getOrCreateTag(tagKey).contains(registry.wrapAsHolder(value));
    }
}

