/*
 * Decompiled with CFR 0.152.
 */
package artifacts.util;

import artifacts.component.ability.AttributeModifiers;
import artifacts.component.ability.EntityCondition;
import artifacts.component.ability.EquipmentAbility;
import artifacts.component.ability.mobeffect.AttackEffects;
import artifacts.component.ability.mobeffect.EquipmentMobEffects;
import artifacts.component.ability.mobeffect.MobEffectProvider;
import artifacts.component.ability.mobeffect.PostDamageEffects;
import artifacts.component.ability.mobeffect.PostEatingEffects;
import artifacts.registry.ModDataComponents;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Unique;

public class TooltipHelper {
    public static void addAttributeTooltips(Consumer<Component> consumer, ItemStack stack, Item.TooltipContext context) {
        ItemAttributeModifiers itemAttributeModifiers = (ItemAttributeModifiers)stack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        boolean hasSlotTooltip = false;
        if (itemAttributeModifiers.showInTooltip()) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                MutableBoolean b = new MutableBoolean(false);
                stack.forEachModifier(slot, (holder, attributeModifier) -> b.setTrue());
                if (!b.booleanValue()) continue;
                hasSlotTooltip = true;
                TooltipHelper.addAbilityAttributeTooltips(stack, context, consumer);
            }
        }
        if (!hasSlotTooltip) {
            if (TooltipHelper.getAbility(ModDataComponents.ATTRIBUTE_MODIFIERS.get(), stack).isPresent() || TooltipHelper.getAbility(ModDataComponents.MOB_EFFECTS.get(), stack).isPresent()) {
                consumer.accept(CommonComponents.EMPTY);
                consumer.accept((Component)Component.translatable((String)"item.modifiers.body").withStyle(ChatFormatting.GRAY));
            }
            TooltipHelper.addAbilityAttributeTooltips(stack, context, consumer);
        }
        TooltipHelper.addWhenHurtTooltips(consumer, context, stack);
        TooltipHelper.addPerFoodPointEatenTooltip(consumer, context, stack);
        TooltipHelper.addAttacksInflictTooltip(consumer, context, stack);
    }

    @Unique
    private static void addAbilityAttributeTooltips(ItemStack stack, Item.TooltipContext context, Consumer<Component> tooltip) {
        TooltipHelper.getAbility(ModDataComponents.ATTRIBUTE_MODIFIERS.get(), stack).ifPresent(ability -> {
            for (AttributeModifiers.Entry entry : ability.entries()) {
                TooltipHelper.addAbilityAttributeTooltip(tooltip, entry);
            }
        });
        TooltipHelper.getAbility(ModDataComponents.MOB_EFFECTS.get(), stack).ifPresent(ability -> {
            for (EquipmentMobEffects.Entry entry : ability.entries()) {
                MobEffectProvider provider = entry.provider();
                TooltipHelper.addMobEffectTooltip(tooltip, context, (MobEffect)provider.mobEffect().value(), (Integer)provider.duration().get(), (Integer)provider.level().get(), 1.0, provider.condition() == EntityCondition.ALWAYS);
            }
        });
    }

    @Unique
    private static void addAbilityAttributeTooltip(Consumer<Component> tooltip, AttributeModifiers.Entry entry) {
        double amount = (Double)entry.amount().get();
        if (entry.operation() != AttributeModifier.Operation.ADD_VALUE) {
            amount *= 100.0;
        } else if (entry.attribute().equals((Object)Attributes.KNOCKBACK_RESISTANCE)) {
            amount *= 10.0;
        }
        if (amount > 0.0) {
            tooltip.accept((Component)Component.translatable((String)("attribute.modifier.plus." + entry.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(amount), Component.translatable((String)((Attribute)entry.attribute().value()).getDescriptionId())}).withStyle(((Attribute)entry.attribute().value()).getStyle(true)));
        } else if (amount < 0.0) {
            tooltip.accept((Component)Component.translatable((String)("attribute.modifier.take." + entry.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(amount *= -1.0), Component.translatable((String)((Attribute)entry.attribute().value()).getDescriptionId())}).withStyle(((Attribute)entry.attribute().value()).getStyle(false)));
        }
    }

    @Unique
    private static void addWhenHurtTooltips(Consumer<Component> tooltip, Item.TooltipContext context, ItemStack stack) {
        MutableBoolean flag = new MutableBoolean(false);
        ArrayList list = new ArrayList();
        TooltipHelper.getAbility(ModDataComponents.POST_DAMAGE_EFFECTS.get(), stack).ifPresent(ability -> {
            for (PostDamageEffects.Entry entry : ability.entries()) {
                if (entry.tag().isEmpty()) {
                    flag.setTrue();
                    continue;
                }
                list.add(entry.tag().get());
            }
        });
        TooltipHelper.getAbility(ModDataComponents.POST_DAMAGE_COOLDOWN.get(), stack).ifPresent(ability -> {
            if (ability.tag().isEmpty()) {
                flag.setTrue();
            } else if (!list.contains(ability.tag().get())) {
                list.add(ability.tag().get());
            }
        });
        if (flag.booleanValue()) {
            tooltip.accept(CommonComponents.EMPTY);
            tooltip.accept((Component)Component.translatable((String)"artifacts.tooltip.when_hurt").withStyle(ChatFormatting.GRAY));
            TooltipHelper.addWhenHurtTooltip(tooltip, context, stack, null);
        }
        for (TagKey tag : list) {
            tooltip.accept(CommonComponents.EMPTY);
            tooltip.accept((Component)Component.translatable((String)"artifacts.tooltip.when_hurt.%s".formatted(tag.location().toString().replace("minecraft:", "").replace(':', '.'))).withStyle(ChatFormatting.GRAY));
            TooltipHelper.addWhenHurtTooltip(tooltip, context, stack, (TagKey<DamageType>)tag);
        }
    }

    private static void addWhenHurtTooltip(Consumer<Component> tooltip, Item.TooltipContext context, ItemStack stack, @Nullable TagKey<DamageType> tag) {
        TooltipHelper.getAbility(ModDataComponents.POST_DAMAGE_EFFECTS.get(), stack).ifPresent(ability -> {
            for (PostDamageEffects.Entry entry : ability.entries()) {
                if ((!entry.tag().isEmpty() || tag != null) && (!entry.tag().isPresent() || !entry.tag().get().equals((Object)tag))) continue;
                TooltipHelper.addMobEffectTooltip(tooltip, context, (MobEffect)entry.provider().mobEffect().value(), (Integer)entry.provider().duration().get(), (Integer)entry.provider().level().get(), (Double)entry.chance().get(), false);
            }
        });
        TooltipHelper.getAbility(ModDataComponents.POST_DAMAGE_COOLDOWN.get(), stack).ifPresent(ability -> {
            if (ability.tag().isEmpty() && tag == null || ability.tag().isPresent() && ability.tag().get().equals((Object)tag)) {
                tooltip.accept((Component)Component.translatable((String)"artifacts.tooltip.cooldown", (Object[])new Object[]{TooltipHelper.formatDurationSeconds(context, (Integer)ability.cooldown().get())}).withStyle(ChatFormatting.GOLD));
            }
        });
    }

    private static void addPerFoodPointEatenTooltip(Consumer<Component> tooltip, Item.TooltipContext context, ItemStack stack) {
        TooltipHelper.getAbility(ModDataComponents.POST_EATING_EFFECTS.get(), stack).ifPresent(ability -> {
            tooltip.accept(CommonComponents.EMPTY);
            tooltip.accept((Component)Component.translatable((String)"artifacts.tooltip.per_food_point_restored").withStyle(ChatFormatting.GRAY));
            for (PostEatingEffects.Entry entry : ability.entries()) {
                MobEffectProvider provider = entry.provider();
                TooltipHelper.addMobEffectTooltip(tooltip, context, (MobEffect)provider.mobEffect().value(), (Integer)provider.duration().get(), (Integer)provider.level().get(), 1.0, false);
            }
        });
    }

    private static void addAttacksInflictTooltip(Consumer<Component> tooltip, Item.TooltipContext context, ItemStack stack) {
        TooltipHelper.getAbility(ModDataComponents.ATTACK_EFFECTS.get(), stack).ifPresent(ability -> {
            tooltip.accept(CommonComponents.EMPTY);
            tooltip.accept((Component)Component.translatable((String)"artifacts.tooltip.attacks_inflict").withStyle(ChatFormatting.GRAY));
            for (AttackEffects.Entry entry : ability.entries()) {
                TooltipHelper.addMobEffectTooltip(tooltip, context, (MobEffect)entry.provider().mobEffect().value(), (Integer)entry.provider().duration().get(), (Integer)entry.provider().level().get(), (Double)entry.chance().get(), false);
                if ((Integer)entry.cooldown().get() <= 0) continue;
                tooltip.accept((Component)Component.translatable((String)"artifacts.tooltip.cooldown", (Object[])new Object[]{TooltipHelper.formatDurationSeconds(context, (Integer)entry.cooldown().get())}).withStyle(ChatFormatting.GOLD));
            }
        });
    }

    private static void addMobEffectTooltip(Consumer<Component> tooltip, Item.TooltipContext context, MobEffect mobEffect, int duration, int level, double chance, boolean isInfinite) {
        MutableComponent mutableComponent = Component.translatable((String)mobEffect.getDescriptionId());
        if (level > 1) {
            mutableComponent = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{mutableComponent, Component.translatable((String)("potion.potency." + (level - 1)))});
        }
        if (!isInfinite) {
            mutableComponent = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{mutableComponent, TooltipHelper.formatDurationSeconds(context, duration)});
        }
        if (Mth.equal((double)chance, (double)1.0)) {
            tooltip.accept((Component)Component.translatable((String)"artifacts.tooltip.plus_mob_effect", (Object[])new Object[]{mutableComponent}).withStyle(mobEffect.getCategory().getTooltipFormatting()));
        } else {
            tooltip.accept((Component)Component.translatable((String)"artifacts.tooltip.plus_mob_effect_chance", (Object[])new Object[]{mutableComponent, Math.round(chance * 100.0)}).withStyle(mobEffect.getCategory().getTooltipFormatting()));
        }
    }

    private static MutableComponent formatDurationSeconds(Item.TooltipContext context, int seconds) {
        return Component.literal((String)StringUtil.formatTickDuration((int)(seconds * 20), (float)context.tickRate()));
    }

    public static <A extends EquipmentAbility> Optional<A> getAbility(DataComponentType<A> type, ItemStack stack) {
        EquipmentAbility ability;
        Object object = stack.get(type);
        if (object instanceof EquipmentAbility && (ability = (EquipmentAbility)object).isNonCosmetic()) {
            return Optional.of(ability);
        }
        return Optional.empty();
    }

    public static boolean isCosmetic(ItemStack stack) {
        for (TypedDataComponent component : stack.getComponents()) {
            EquipmentAbility ability;
            Object object = component.value();
            if (!(object instanceof EquipmentAbility) || !(ability = (EquipmentAbility)object).isNonCosmetic()) continue;
            return false;
        }
        return true;
    }
}

