/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.athena.impl.loading;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.resources.model.BlockStateModelLoader;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;

public class AthenaResourceLoader
extends SimpleJsonResourceReloadListener {
    public static final AthenaResourceLoader INSTANCE = new AthenaResourceLoader();
    private Function<ResourceLocation, List<BlockStateModelLoader.LoadedJson>> getter = id -> null;
    private final Map<ResourceLocation, JsonElement> data = new HashMap<ResourceLocation, JsonElement>();

    public AthenaResourceLoader() {
        super(new Gson(), "athena");
    }

    public void setGetter(Function<ResourceLocation, List<BlockStateModelLoader.LoadedJson>> getter) {
        this.getter = Objects.requireNonNullElse(getter, id -> null);
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        this.data.clear();
        this.data.putAll(object);
    }

    public static JsonObject getData(ResourceLocation modelType, ResourceLocation modelId) {
        JsonElement modelData = AthenaResourceLoader.INSTANCE.data.get(modelId);
        if (modelData != null) {
            return AthenaResourceLoader.checkObject(modelType, modelData);
        }
        List<BlockStateModelLoader.LoadedJson> jsons = AthenaResourceLoader.INSTANCE.getter.apply(AthenaResourceLoader.convertModelIdToBlockStatePath(modelId));
        if (jsons == null) {
            return null;
        }
        for (BlockStateModelLoader.LoadedJson json : jsons) {
            JsonObject object = AthenaResourceLoader.checkObject(modelType, json.data());
            if (object == null) continue;
            return object;
        }
        return null;
    }

    private static JsonObject checkObject(ResourceLocation modelType, JsonElement data) {
        if (data instanceof JsonObject) {
            JsonObject object = (JsonObject)data;
            String type = GsonHelper.getAsString((JsonObject)object, (String)"athena:loader", (String)"");
            if (modelType.toString().equals(type)) {
                return object;
            }
        }
        return null;
    }

    private static ResourceLocation convertModelIdToBlockStatePath(ResourceLocation modelId) {
        return ResourceLocation.fromNamespaceAndPath((String)modelId.getNamespace(), (String)("blockstates/" + modelId.getPath() + ".json"));
    }
}

