/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.atlasapi.internal;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.math.Transformation;
import io.redspace.atlasapi.AtlasApi;
import io.redspace.atlasapi.api.AssetHandler;
import io.redspace.atlasapi.api.AtlasApiRegistry;
import io.redspace.atlasapi.api.data.BakingPreparations;
import io.redspace.atlasapi.api.data.ModelLayer;
import io.redspace.atlasapi.internal.ClientManager;
import io.redspace.atlasapi.internal.DynamicAtlas;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.NeoForgeRenderTypes;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.model.CompositeModel;
import net.neoforged.neoforge.client.model.EmptyModel;
import net.neoforged.neoforge.client.model.SimpleModelState;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import net.neoforged.neoforge.client.model.geometry.UnbakedGeometryHelper;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class DynamicAtlasModel
implements IUnbakedGeometry<DynamicAtlasModel> {
    final Holder<AssetHandler> handler;

    public DynamicAtlasModel(Holder<AssetHandler> handler) {
        this.handler = handler;
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides) {
        return new Baked((pModel, pStack, pLevel, pEntity, pSeed) -> {
            AssetHandler _handler = (AssetHandler)this.handler.value();
            int id = _handler.modelId(pStack, pLevel, pEntity, pSeed);
            return ClientManager.getModelOrCompute(this.handler.getKey().location(), id, i -> DynamicAtlasModel.bake(_handler, _handler.makeBakedModelPreparations(pStack, pLevel, pEntity, pSeed), context, modelState, overrides));
        }, baker);
    }

    public static BakedModel bake(AssetHandler handler, BakingPreparations preparations, IGeometryBakingContext context, ModelState modelState, ItemOverrides overrides) {
        AtlasApi.LOGGER.debug("DynamicAtlasModel bake: {}", (Object)preparations);
        DynamicAtlas atlas = ClientManager.getAtlas(handler);
        List<ModelLayer> layers = preparations.layers().stream().sorted(Comparator.comparingInt(ModelLayer::drawOrder)).toList();
        if (!layers.isEmpty()) {
            TextureAtlasSprite particle = atlas.getSprite(layers.getFirst().spriteLocation());
            CompositeModel.Baked.Builder builder = CompositeModel.Baked.builder((IGeometryBakingContext)context, (TextureAtlasSprite)particle, (ItemOverrides)overrides, (ItemTransforms)context.getTransforms());
            Transformation rootTransform = context.getRootTransform();
            for (int i = 0; i < layers.size(); ++i) {
                ModelLayer layer = layers.get(i);
                TextureAtlasSprite sprite = atlas.getSprite(layer.spriteLocation());
                Transformation transformation = layer.transformation().orElse(new Transformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quaternionf(), new Vector3f(1.0f, 1.0f, 1.0f), new Quaternionf()));
                SimpleModelState subState = new SimpleModelState(modelState.getRotation().compose(rootTransform.compose(transformation)), modelState.isUvLocked());
                List unbaked = UnbakedGeometryHelper.createUnbakedItemElements((int)i, (TextureAtlasSprite)sprite);
                List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, material2 -> sprite, (ModelState)subState);
                RenderTypeGroup renderTypes = new RenderTypeGroup(RenderType.solid(), NeoForgeRenderTypes.getUnsortedTranslucent((ResourceLocation)handler.getAtlasLocation()));
                builder.addQuads(renderTypes, (Collection)quads);
            }
            return builder.build();
        }
        return EmptyModel.BAKED;
    }

    public static class Baked
    implements BakedModel {
        BakedModel noopModel = EmptyModel.BAKED;
        ItemOverrides overrides;

        public Baked(final BakedModelSupplier modelSupplier, ModelBaker baker) {
            BlockModel blockmodel = (BlockModel)baker.getModel(ModelBakery.MISSING_MODEL_LOCATION);
            this.overrides = new ItemOverrides(this, baker, (UnbakedModel)blockmodel, List.of(), baker.getModelTextureGetter()){

                @Nullable
                public BakedModel resolve(BakedModel pModel, ItemStack pStack, @Nullable ClientLevel pLevel, @Nullable LivingEntity pEntity, int pSeed) {
                    return modelSupplier.get(pModel, pStack, pLevel, pEntity, pSeed);
                }
            };
        }

        public List<BakedQuad> getQuads(@Nullable BlockState pState, @Nullable Direction pDirection, RandomSource pRandom) {
            return this.noopModel.getQuads(pState, pDirection, pRandom);
        }

        public boolean useAmbientOcclusion() {
            return this.noopModel.useAmbientOcclusion();
        }

        public boolean isGui3d() {
            return this.noopModel.isGui3d();
        }

        public boolean usesBlockLight() {
            return this.noopModel.usesBlockLight();
        }

        public boolean isCustomRenderer() {
            return this.noopModel.isCustomRenderer();
        }

        public TextureAtlasSprite getParticleIcon() {
            return this.noopModel.getParticleIcon();
        }

        public ItemOverrides getOverrides() {
            return this.overrides;
        }

        public ItemTransforms getTransforms() {
            return this.noopModel.getTransforms();
        }

        public static interface BakedModelSupplier {
            public BakedModel get(BakedModel var1, ItemStack var2, @Nullable ClientLevel var3, @Nullable LivingEntity var4, int var5);
        }
    }

    public static final class Loader
    implements IGeometryLoader<DynamicAtlasModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public DynamicAtlasModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
            try {
                String typestring = jsonObject.get("handler").getAsString();
                Holder.Reference type = AtlasApiRegistry.ASSET_HANDLER_REGISTRY.getHolderOrThrow(ResourceKey.create(AtlasApiRegistry.ASSET_HANDLER_REGISTRY_KEY, (ResourceLocation)ResourceLocation.parse((String)typestring)));
                return new DynamicAtlasModel((Holder<AssetHandler>)type);
            }
            catch (Exception e) {
                throw new JsonParseException(e.getMessage());
            }
        }
    }
}

