/*
 * Decompiled with CFR 0.152.
 */
package com.traverse.bhc.common.items;

import com.traverse.bhc.common.BaubleyHeartCanisters;
import com.traverse.bhc.common.items.BaseItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ItemHeartPatch
extends BaseItem {
    protected final int amount;
    protected final int cooldown;
    protected final int durabilty;
    protected final int color;

    public ItemHeartPatch(int healAmount, int cooldown, int durabilty, int color) {
        super(1);
        this.amount = healAmount;
        this.cooldown = cooldown;
        this.durabilty = durabilty;
        this.color = color;
    }

    public boolean isDamageable(ItemStack stack) {
        return true;
    }

    public int getMaxDamage(ItemStack stack) {
        return this.durabilty;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        playerIn.playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), 0.5f, worldIn.getRandom().nextFloat() * 0.4f / 0.4f / 0.8f);
        if (!worldIn.isClientSide()) {
            playerIn.getCooldowns().addCooldown(stack.getItem(), this.cooldown);
            playerIn.heal((float)this.amount);
            stack.setDamageValue(stack.getDamageValue() + 1);
            if (!playerIn.isCreative() && stack.getDamageValue() >= stack.getMaxDamage()) {
                stack.shrink(1);
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)worldIn.isClientSide());
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarColor(ItemStack stack) {
        return this.color;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)Util.makeDescriptionId((String)"tooltip", (ResourceLocation)BaubleyHeartCanisters.id("patch_amount")), (Object[])new Object[]{this.amount}).setStyle(Style.EMPTY.applyFormat(ChatFormatting.RED)));
        tooltipComponents.add((Component)Component.translatable((String)Util.makeDescriptionId((String)"tooltip", (ResourceLocation)BaubleyHeartCanisters.id("patch_durability")), (Object[])new Object[]{this.durabilty - stack.getDamageValue()}).setStyle(Style.EMPTY.applyFormat(ChatFormatting.BLUE)));
    }
}

