/*
 * Decompiled with CFR 0.152.
 */
package com.traverse.bhc.common.util;

import com.traverse.bhc.common.BaubleyHeartCanisters;
import com.traverse.bhc.common.init.RegistryHandler;
import com.traverse.bhc.common.util.HeartType;
import java.util.Arrays;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;

public class HealthModifier {
    public static final ResourceLocation HEALTH_MODIFIER_ID = BaubleyHeartCanisters.id("extra_health");

    public static void updatePlayerHealth(Player player, ItemStack stack, boolean addHealth) {
        AttributeModifier modifier;
        AttributeInstance health = player.getAttribute(Attributes.MAX_HEALTH);
        if (health == null) {
            return;
        }
        float diff = player.getMaxHealth() - player.getHealth();
        int extraHearts = 0;
        if (addHealth) {
            extraHearts = HealthModifier.getHeartCount(stack) * 2;
        }
        if ((modifier = health.getModifier(HEALTH_MODIFIER_ID)) != null) {
            if (modifier.amount() == (double)extraHearts) {
                return;
            }
            health.removeModifier(HEALTH_MODIFIER_ID);
        }
        health.addPermanentModifier(new AttributeModifier(HEALTH_MODIFIER_ID, (double)extraHearts, AttributeModifier.Operation.ADD_VALUE));
        float newHealth = Mth.clamp((float)(player.getMaxHealth() - diff), (float)0.0f, (float)player.getMaxHealth());
        if (newHealth > 0.0f) {
            player.setHealth(newHealth);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.resetSentInfo();
            }
        } else {
            player.closeContainer();
            player.kill();
        }
    }

    public static int[] getHeartValues(ItemStack stack) {
        int valuesLength = HeartType.values().length;
        if (!stack.has(RegistryHandler.STORED_HEARTS_COMPONENT)) {
            return new int[valuesLength];
        }
        int[] values = ((ItemContainerContents)stack.get(RegistryHandler.STORED_HEARTS_COMPONENT)).stream().mapToInt(ItemStack::getCount).toArray();
        if (values.length != valuesLength) {
            return Arrays.copyOf(values, valuesLength);
        }
        return values;
    }

    public static int getHeartCount(ItemStack stack) {
        int sum = 0;
        for (int hearts : HealthModifier.getHeartValues(stack)) {
            sum += hearts;
        }
        return sum;
    }
}

