/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.beer;

import com.breakinblocks.beer.Config;
import com.breakinblocks.beer.data.BeerDataAttachments;
import com.breakinblocks.beer.recipe.BeerRecipes;
import com.breakinblocks.beer.recipe.EnchantingModifierRecipeType;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartedEvent;

@Mod(value="beer")
public class Beer {
    public static final String MODID = "beer";

    public static final ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    public Beer(IEventBus modEventBus, ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        BeerDataAttachments.register(modEventBus);
        BeerRecipes.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        RecipeManager recipeManager = event.getServer().getRecipeManager();
        RecipeType<EnchantingModifierRecipeType> recipeType = BeerRecipes.ENCHANTING_MODIFIER_TYPE.get();
        if (recipeType != null) {
            List recipes = recipeManager.getAllRecipesFor(recipeType);
            recipes.forEach(recipeHolder -> {});
        }
    }
}

