/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.beer.network;

import com.breakinblocks.beer.Beer;
import com.breakinblocks.beer.data.EnchantingTableRangeData;
import com.breakinblocks.beer.network.NetworkHandler;
import com.breakinblocks.beer.network.SyncEnchantingDataPacket;
import com.breakinblocks.beer.util.EnchantingTableDataUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record UpdateRangePacket(BlockPos pos, int rangeX, int rangeY, int rangeZ) implements CustomPacketPayload
{
    private static final double MAX_INTERACTION_DISTANCE_SQ = 64.0;
    private static final double BLOCK_CENTER_OFFSET = 0.5;
    public static final CustomPacketPayload.Type<UpdateRangePacket> TYPE = new CustomPacketPayload.Type(Beer.rl("update_range"));
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdateRangePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, UpdateRangePacket::pos, (StreamCodec)ByteBufCodecs.INT, UpdateRangePacket::rangeX, (StreamCodec)ByteBufCodecs.INT, UpdateRangePacket::rangeY, (StreamCodec)ByteBufCodecs.INT, UpdateRangePacket::rangeZ, UpdateRangePacket::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(UpdateRangePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (!context.flow().isServerbound()) {
                return;
            }
            Player player = context.player();
            if (!UpdateRangePacket.isValidContext(player)) {
                return;
            }
            if (!EnchantingTableDataUtil.hasEnchantingTable(player.level(), packet.pos())) {
                return;
            }
            if (!UpdateRangePacket.isPlayerInRange(player, packet.pos())) {
                return;
            }
            UpdateRangePacket.updateRangeData(packet, player);
        });
    }

    private static boolean isValidContext(Player player) {
        return player != null;
    }

    private static boolean isPlayerInRange(Player player, BlockPos pos) {
        double distance = player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
        return distance <= 64.0;
    }

    private static void updateRangeData(UpdateRangePacket packet, Player player) {
        EnchantingTableDataUtil.setRanges(player.level(), packet.pos(), packet.rangeX(), packet.rangeY(), packet.rangeZ());
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            EnchantingTableRangeData updatedData = EnchantingTableDataUtil.getRangeData(player.level(), packet.pos());
            SyncEnchantingDataPacket syncPacket = SyncEnchantingDataPacket.create(packet.pos(), updatedData);
            NetworkHandler.sendToPlayersNear(syncPacket, serverLevel, packet.pos(), 64.0);
        }
    }
}

