/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.beer.recipe;

import com.breakinblocks.beer.compat.EnchantingModifierRecipe;
import com.breakinblocks.beer.recipe.BeerRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class EnchantingModifierRecipeType
implements Recipe<RecipeInput> {
    public static final Serializer SERIALIZER = new Serializer();
    private final Ingredient mainhandInput;
    private final Ingredient offhandInput;
    private final boolean consumesOffhand;
    private final String effectKey;
    private final String descriptionKey;
    private final EnchantingModifierRecipe.ModifierType modifierType;

    public EnchantingModifierRecipeType(Ingredient mainhandInput, Ingredient offhandInput, boolean consumesOffhand, String effectKey, String descriptionKey, EnchantingModifierRecipe.ModifierType modifierType) {
        this.mainhandInput = mainhandInput;
        this.offhandInput = offhandInput;
        this.consumesOffhand = consumesOffhand;
        this.effectKey = effectKey;
        this.descriptionKey = descriptionKey;
        this.modifierType = modifierType;
    }

    public boolean matches(RecipeInput input, Level level) {
        return true;
    }

    public ItemStack assemble(RecipeInput input, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public RecipeType<?> getType() {
        return BeerRecipes.ENCHANTING_MODIFIER_TYPE.get();
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredients = NonNullList.create();
        ingredients.add((Object)this.mainhandInput);
        if (this.offhandInput != Ingredient.EMPTY) {
            ingredients.add((Object)this.offhandInput);
        }
        return ingredients;
    }

    public EnchantingModifierRecipe toJEIRecipe() {
        return new EnchantingModifierRecipe(this.mainhandInput, this.offhandInput, this.consumesOffhand, this.effectKey, this.descriptionKey, this.modifierType);
    }

    public Ingredient getMainhandInput() {
        return this.mainhandInput;
    }

    public Ingredient getOffhandInput() {
        return this.offhandInput;
    }

    public boolean consumesOffhand() {
        return this.consumesOffhand;
    }

    public String getEffectKey() {
        return this.effectKey;
    }

    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    public EnchantingModifierRecipe.ModifierType getModifierType() {
        return this.modifierType;
    }

    public static class Serializer
    implements RecipeSerializer<EnchantingModifierRecipeType> {
        public static final MapCodec<EnchantingModifierRecipeType> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("mainhand_input").forGetter(EnchantingModifierRecipeType::getMainhandInput), (App)Ingredient.CODEC.optionalFieldOf("offhand_input", (Object)Ingredient.EMPTY).forGetter(EnchantingModifierRecipeType::getOffhandInput), (App)Codec.BOOL.optionalFieldOf("consumes_offhand", (Object)false).forGetter(EnchantingModifierRecipeType::consumesOffhand), (App)Codec.STRING.fieldOf("effect_key").forGetter(EnchantingModifierRecipeType::getEffectKey), (App)Codec.STRING.fieldOf("description_key").forGetter(EnchantingModifierRecipeType::getDescriptionKey), (App)Codec.stringResolver(Enum::name, EnchantingModifierRecipe.ModifierType::valueOf).fieldOf("modifier_type").forGetter(EnchantingModifierRecipeType::getModifierType)).apply((Applicative)instance, (mainhand, offhand, consumes, effect, desc, type) -> {
            LogUtils.getLogger().info("[BEER] Creating EnchantingModifierRecipeType: {} ({})", effect, (Object)type);
            return new EnchantingModifierRecipeType((Ingredient)mainhand, (Ingredient)offhand, (boolean)consumes, (String)effect, (String)desc, (EnchantingModifierRecipe.ModifierType)((Object)((Object)type)));
        }));
        public static final StreamCodec<RegistryFriendlyByteBuf, EnchantingModifierRecipeType> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, EnchantingModifierRecipeType::getMainhandInput, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, EnchantingModifierRecipeType::getOffhandInput, (StreamCodec)ByteBufCodecs.BOOL, EnchantingModifierRecipeType::consumesOffhand, (StreamCodec)ByteBufCodecs.STRING_UTF8, EnchantingModifierRecipeType::getEffectKey, (StreamCodec)ByteBufCodecs.STRING_UTF8, EnchantingModifierRecipeType::getDescriptionKey, (StreamCodec)ByteBufCodecs.STRING_UTF8.map(EnchantingModifierRecipe.ModifierType::valueOf, Enum::name), EnchantingModifierRecipeType::getModifierType, EnchantingModifierRecipeType::new);

        public MapCodec<EnchantingModifierRecipeType> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, EnchantingModifierRecipeType> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

