/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.beer.util;

import com.breakinblocks.beer.data.BeerDataAttachments;
import com.breakinblocks.beer.data.EnchantingTableRangeData;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.EnchantingTableBlockEntity;

public class EnchantingTableDataUtil {
    public static EnchantingTableRangeData getRangeData(Level level, BlockPos pos) {
        EnchantingTableBlockEntity enchantingTable;
        EnchantingTableRangeData data;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof EnchantingTableBlockEntity && (data = (EnchantingTableRangeData)(enchantingTable = (EnchantingTableBlockEntity)blockEntity).getData(BeerDataAttachments.ENCHANTING_TABLE_RANGE.get())) != null) {
            return data;
        }
        EnchantingTableRangeData newData = new EnchantingTableRangeData();
        return newData;
    }

    public static void setRangeData(Level level, BlockPos pos, EnchantingTableRangeData data) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof EnchantingTableBlockEntity) {
            EnchantingTableBlockEntity enchantingTable = (EnchantingTableBlockEntity)blockEntity;
            enchantingTable.setData(BeerDataAttachments.ENCHANTING_TABLE_RANGE.get(), (Object)data);
            enchantingTable.setChanged();
        }
    }

    public static void setRanges(Level level, BlockPos pos, int rangeX, int rangeY, int rangeZ) {
        EnchantingTableRangeData data = EnchantingTableDataUtil.getRangeData(level, pos);
        data.setItemModifierZ(rangeZ);
        data.setItemModifierY(rangeY);
        data.setItemModifierX(rangeX);
        EnchantingTableDataUtil.setRangeData(level, pos, data);
    }

    public static boolean hasEnchantingTable(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        return blockEntity instanceof EnchantingTableBlockEntity;
    }

    public static int[] getEffectiveBoundingBoxSizes(Level level, BlockPos pos) {
        EnchantingTableRangeData data = EnchantingTableDataUtil.getRangeData(level, pos);
        return new int[]{Math.max(1, data.getEffectiveRangeX() * 2 + 1), Math.max(1, data.getEffectiveRangeY() + 1), Math.max(1, data.getEffectiveRangeZ() * 2 + 1)};
    }

    public static void resetToDefaults(Level level, BlockPos pos) {
        EnchantingTableRangeData data = EnchantingTableDataUtil.getRangeData(level, pos);
        data.resetToDefaults();
        EnchantingTableDataUtil.setRangeData(level, pos, data);
    }

    public static void forceResetAll(Level level, BlockPos pos) {
        EnchantingTableRangeData data = new EnchantingTableRangeData();
        EnchantingTableDataUtil.setRangeData(level, pos, data);
    }
}

