/*
 * Decompiled with CFR 0.152.
 */
package rearth.belts.neoforge;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;
import rearth.belts.Belts;
import rearth.belts.api.item.BlockItemApi;
import rearth.belts.api.item.ItemApi;

public class NeoforgeItemApiImpl
implements BlockItemApi {
    @Override
    public ItemApi.InventoryStorage find(Level world, BlockPos pos, @Nullable BlockState state, @Nullable BlockEntity entity, @Nullable Direction direction) {
        IItemHandler candidate = (IItemHandler)world.getCapability(Capabilities.ItemHandler.BLOCK, pos, state, entity, (Object)direction);
        if (candidate == null) {
            return null;
        }
        return new NeoforgeStoragerWrapper(candidate);
    }

    public static class NeoforgeStoragerWrapper
    implements ItemApi.InventoryStorage {
        private final IItemHandler container;

        public NeoforgeStoragerWrapper(IItemHandler candidate) {
            this.container = candidate;
        }

        @Override
        public int insert(ItemStack inserted, boolean simulate) {
            return inserted.getCount() - ItemHandlerHelper.insertItem((IItemHandler)this.container, (ItemStack)inserted, (boolean)simulate).getCount();
        }

        @Override
        public int insertToSlot(ItemStack inserted, int slot, boolean simulate) {
            return inserted.getCount() - this.container.insertItem(slot, inserted, simulate).getCount();
        }

        @Override
        public int extract(ItemStack extracted, boolean simulate) {
            int total = 0;
            for (int i = 0; i < this.container.getSlots(); ++i) {
                ItemStack available = this.container.getStackInSlot(i);
                if (!ItemStack.isSameItemSameComponents((ItemStack)available, (ItemStack)extracted)) continue;
                total += this.container.extractItem(i, extracted.getCount() - total, simulate).getCount();
            }
            return total;
        }

        @Override
        public int extractFromSlot(ItemStack extracted, int slot, boolean simulate) {
            return this.container.extractItem(slot, extracted.getCount(), simulate).getCount();
        }

        @Override
        public void setStackInSlot(int slot, ItemStack stack) {
            IItemHandler iItemHandler = this.container;
            if (iItemHandler instanceof IItemHandlerModifiable) {
                IItemHandlerModifiable handler = (IItemHandlerModifiable)iItemHandler;
                handler.setStackInSlot(slot, stack);
            } else {
                Belts.LOGGER.error("Unable to set stack in slot: {}, stack is: {}", (Object)slot, (Object)stack);
                Belts.LOGGER.error("This should never happen");
            }
        }

        @Override
        public ItemStack getStackInSlot(int slot) {
            return this.container.getStackInSlot(slot);
        }

        @Override
        public int getSlotCount() {
            return this.container.getSlots();
        }

        @Override
        public int getSlotLimit(int slot) {
            return this.container.getSlotLimit(slot);
        }
    }
}

