/*
 * Decompiled with CFR 0.152.
 */
package net.ricmc.betterblockz.block.custom;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class CobbleTransmuterBlock
extends Block {
    public static final EnumProperty<Mode> MODE = EnumProperty.create((String)"mode", Mode.class);
    private static final int PARTICLE_COUNT = 2;
    private static final double IDLE_PARTICLE_CHANCE = 0.15;
    private static final Map<Supplier<Block>, Supplier<Block>> TRANSMUTATION_RULES = new LinkedHashMap<Supplier<Block>, Supplier<Block>>();

    public CobbleTransmuterBlock(BlockBehaviour.Properties properties) {
        super(properties.randomTicks());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(MODE, (Comparable)((Object)Mode.NORMAL)));
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        if (!level.isClientSide) {
            this.updateMode(level, pos, state);
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
        if (!level.isClientSide) {
            this.updateMode(level, pos, state);
        }
    }

    private void updateMode(Level level, BlockPos pos, BlockState state) {
        BlockState below = level.getBlockState(pos.below());
        Mode newMode = below.is(Blocks.LAVA) ? Mode.LAVA : (below.is(Blocks.WATER) ? Mode.WATER : Mode.NORMAL);
        if (state.getValue(MODE) != newMode) {
            level.setBlock(pos, (BlockState)state.setValue(MODE, (Comparable)((Object)newMode)), 2);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{MODE});
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.is((Block)this)) {
            return;
        }
        Block catalyst = this.detectCatalystBelow(level, pos);
        if (catalyst == null) {
            return;
        }
        Block resultBlock = this.getResultBlockForCatalyst(catalyst);
        if (resultBlock == null) {
            return;
        }
        boolean didTransform = false;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                BlockPos neighborPos;
                BlockState neighbor;
                if (dx == 0 && dz == 0 || !(neighbor = level.getBlockState(neighborPos = pos.offset(dx, 0, dz))).is(Blocks.COBBLESTONE)) continue;
                level.setBlock(neighborPos, resultBlock.defaultBlockState(), 2);
                didTransform = true;
                this.spawnConversionParticles(level, neighborPos, catalyst);
            }
        }
        if (didTransform) {
            level.playSound(null, pos, SoundEvents.STONE_BREAK, SoundSource.BLOCKS, 0.5f, 1.0f + random.nextFloat() * 0.3f);
        } else if (random.nextDouble() < 0.15) {
            this.spawnIdleParticle(level, pos, random, catalyst);
        }
    }

    private Block detectCatalystBelow(ServerLevel level, BlockPos pos) {
        BlockState below = level.getBlockState(pos.below());
        for (Supplier<Block> catalystSupplier : TRANSMUTATION_RULES.keySet()) {
            if (!below.is(catalystSupplier.get())) continue;
            return catalystSupplier.get();
        }
        return null;
    }

    private Block getResultBlockForCatalyst(Block catalyst) {
        for (Map.Entry<Supplier<Block>, Supplier<Block>> entry : TRANSMUTATION_RULES.entrySet()) {
            if (entry.getKey().get() != catalyst) continue;
            return entry.getValue().get();
        }
        return null;
    }

    private void spawnConversionParticles(ServerLevel level, BlockPos pos, Block catalyst) {
        SimpleParticleType particle = catalyst == Blocks.WATER ? ParticleTypes.SPLASH : ParticleTypes.SMOKE;
        level.sendParticles((ParticleOptions)particle, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 2, 0.25, 0.25, 0.25, 0.01);
    }

    private void spawnIdleParticle(ServerLevel level, BlockPos pos, RandomSource random, Block catalyst) {
        SimpleParticleType particle = catalyst == Blocks.WATER ? ParticleTypes.DRIPPING_WATER : ParticleTypes.DRIPPING_LAVA;
        double x = (double)pos.getX() + 0.3 + random.nextDouble() * 0.4;
        double y = (double)pos.getY() + 0.8 + random.nextDouble() * 0.1;
        double z = (double)pos.getZ() + 0.3 + random.nextDouble() * 0.4;
        level.sendParticles((ParticleOptions)particle, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        String baseKey = stack.getItem().getDescriptionId();
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)(baseKey + ".shift.line1")));
            tooltip.add((Component)Component.translatable((String)(baseKey + ".shift.line2")));
            tooltip.add((Component)Component.translatable((String)(baseKey + ".shift.line3")));
        } else {
            tooltip.add((Component)Component.translatable((String)(baseKey + ".tooltip")));
        }
        super.appendHoverText(stack, context, tooltip, flag);
    }

    static {
        TRANSMUTATION_RULES.put(() -> Blocks.LAVA, () -> Blocks.COBBLED_DEEPSLATE);
        TRANSMUTATION_RULES.put(() -> Blocks.WATER, () -> Blocks.MOSSY_COBBLESTONE);
    }

    public static enum Mode implements StringRepresentable
    {
        NORMAL("normal"),
        LAVA("lava"),
        WATER("water");

        private final String name;

        private Mode(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }
    }
}

