/*
 * Decompiled with CFR 0.152.
 */
package net.ricmc.betterblockz.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class ColorCycleRegistry {
    public static final Map<Item, Item> WOOL_CYCLE = new HashMap<Item, Item>();
    public static final Map<Item, Item> GLASS_CYCLE = new HashMap<Item, Item>();
    public static final Map<Item, Item> TERRACOTTA_CYCLE = new HashMap<Item, Item>();

    private static Block getWool(DyeColor color) {
        return switch (color) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> Blocks.WHITE_WOOL;
            case DyeColor.ORANGE -> Blocks.ORANGE_WOOL;
            case DyeColor.MAGENTA -> Blocks.MAGENTA_WOOL;
            case DyeColor.LIGHT_BLUE -> Blocks.LIGHT_BLUE_WOOL;
            case DyeColor.YELLOW -> Blocks.YELLOW_WOOL;
            case DyeColor.LIME -> Blocks.LIME_WOOL;
            case DyeColor.PINK -> Blocks.PINK_WOOL;
            case DyeColor.GRAY -> Blocks.GRAY_WOOL;
            case DyeColor.LIGHT_GRAY -> Blocks.LIGHT_GRAY_WOOL;
            case DyeColor.CYAN -> Blocks.CYAN_WOOL;
            case DyeColor.PURPLE -> Blocks.PURPLE_WOOL;
            case DyeColor.BLUE -> Blocks.BLUE_WOOL;
            case DyeColor.BROWN -> Blocks.BROWN_WOOL;
            case DyeColor.GREEN -> Blocks.GREEN_WOOL;
            case DyeColor.RED -> Blocks.RED_WOOL;
            case DyeColor.BLACK -> Blocks.BLACK_WOOL;
        };
    }

    private static Block getGlass(DyeColor color) {
        return switch (color) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> Blocks.WHITE_STAINED_GLASS;
            case DyeColor.ORANGE -> Blocks.ORANGE_STAINED_GLASS;
            case DyeColor.MAGENTA -> Blocks.MAGENTA_STAINED_GLASS;
            case DyeColor.LIGHT_BLUE -> Blocks.LIGHT_BLUE_STAINED_GLASS;
            case DyeColor.YELLOW -> Blocks.YELLOW_STAINED_GLASS;
            case DyeColor.LIME -> Blocks.LIME_STAINED_GLASS;
            case DyeColor.PINK -> Blocks.PINK_STAINED_GLASS;
            case DyeColor.GRAY -> Blocks.GRAY_STAINED_GLASS;
            case DyeColor.LIGHT_GRAY -> Blocks.LIGHT_GRAY_STAINED_GLASS;
            case DyeColor.CYAN -> Blocks.CYAN_STAINED_GLASS;
            case DyeColor.PURPLE -> Blocks.PURPLE_STAINED_GLASS;
            case DyeColor.BLUE -> Blocks.BLUE_STAINED_GLASS;
            case DyeColor.BROWN -> Blocks.BROWN_STAINED_GLASS;
            case DyeColor.GREEN -> Blocks.GREEN_STAINED_GLASS;
            case DyeColor.RED -> Blocks.RED_STAINED_GLASS;
            case DyeColor.BLACK -> Blocks.BLACK_STAINED_GLASS;
        };
    }

    private static Block getTerracotta(DyeColor color) {
        return switch (color) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> Blocks.WHITE_TERRACOTTA;
            case DyeColor.ORANGE -> Blocks.ORANGE_TERRACOTTA;
            case DyeColor.MAGENTA -> Blocks.MAGENTA_TERRACOTTA;
            case DyeColor.LIGHT_BLUE -> Blocks.LIGHT_BLUE_TERRACOTTA;
            case DyeColor.YELLOW -> Blocks.YELLOW_TERRACOTTA;
            case DyeColor.LIME -> Blocks.LIME_TERRACOTTA;
            case DyeColor.PINK -> Blocks.PINK_TERRACOTTA;
            case DyeColor.GRAY -> Blocks.GRAY_TERRACOTTA;
            case DyeColor.LIGHT_GRAY -> Blocks.LIGHT_GRAY_TERRACOTTA;
            case DyeColor.CYAN -> Blocks.CYAN_TERRACOTTA;
            case DyeColor.PURPLE -> Blocks.PURPLE_TERRACOTTA;
            case DyeColor.BLUE -> Blocks.BLUE_TERRACOTTA;
            case DyeColor.BROWN -> Blocks.BROWN_TERRACOTTA;
            case DyeColor.GREEN -> Blocks.GREEN_TERRACOTTA;
            case DyeColor.RED -> Blocks.RED_TERRACOTTA;
            case DyeColor.BLACK -> Blocks.BLACK_TERRACOTTA;
        };
    }

    static {
        DyeColor[] colors = DyeColor.values();
        for (int i = 0; i < colors.length; ++i) {
            DyeColor current = colors[i];
            DyeColor next = colors[(i + 1) % colors.length];
            WOOL_CYCLE.put(ColorCycleRegistry.getWool(current).asItem(), ColorCycleRegistry.getWool(next).asItem());
            GLASS_CYCLE.put(ColorCycleRegistry.getGlass(current).asItem(), ColorCycleRegistry.getGlass(next).asItem());
            TERRACOTTA_CYCLE.put(ColorCycleRegistry.getTerracotta(current).asItem(), ColorCycleRegistry.getTerracotta(next).asItem());
        }
    }
}

