/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.blocks;

import com.davenonymous.bonsaitrees.blocks.BonsaiPotBlockEntity;
import com.davenonymous.bonsaitrees.blocks.BonsaiPotContainer;
import com.davenonymous.bonsaitrees.datacomponents.CamouflageDataComponent;
import com.davenonymous.bonsaitrees.datacomponents.RedstoneModeDataComponent;
import com.davenonymous.bonsaitrees.datacomponents.SaplingDataComponent;
import com.davenonymous.bonsaitrees.datacomponents.SoilDataComponent;
import com.davenonymous.bonsaitrees.datacomponents.ToolDataComponent;
import com.davenonymous.bonsaitrees.setup.ModBlocks;
import com.davenonymous.bonsaitrees.setup.ModDataComponents;
import com.davenonymous.bonsaitrees.setup.data.BonsaiInfo;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.Nullable;

public class BonsaiPotBlock
extends Block
implements EntityBlock,
Equipable,
SimpleWaterloggedBlock {
    private final VoxelShape SHAPE = Shapes.box((double)0.065f, (double)0.005f, (double)0.065f, (double)0.935f, (double)0.185f, (double)0.935f);
    public static final ModelProperty<ResourceLocation> SAPLING = new ModelProperty();
    public static final ModelProperty<Block> SOIL = new ModelProperty();
    public static final ModelProperty<Fluid> FLUID_SOIL = new ModelProperty();
    public static final ModelProperty<Item> ITEM_SOIL = new ModelProperty();
    public static final ModelProperty<Block> CAMOUFLAGE = new ModelProperty();

    public BonsaiPotBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.DECORATED_POT).strength(2.0f).requiresCorrectToolForDrops());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (blockEntityType == ModBlocks.BONSAI_POT_ENTITY.get()) {
            return (level1, blockPos, blockState, blockEntity) -> {
                if (blockEntity instanceof BonsaiPotBlockEntity) {
                    BonsaiPotBlockEntity bonsaiPot = (BonsaiPotBlockEntity)blockEntity;
                    bonsaiPot.tick();
                }
            };
        }
        return null;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BonsaiPotBlockEntity) {
            BonsaiPotBlockEntity bonsaiPot = (BonsaiPotBlockEntity)blockEntity;
            ItemStack clone = new ItemStack((ItemLike)this, 1);
            DataComponentMap components = bonsaiPot.collectComponents();
            if (components.has((DataComponentType)ModDataComponents.CAMOUFLAGE_COMPONENT.get())) {
                clone.set((DataComponentType)ModDataComponents.CAMOUFLAGE_COMPONENT.get(), (Object)((CamouflageDataComponent)components.get((DataComponentType)ModDataComponents.CAMOUFLAGE_COMPONENT.get())));
            }
            if (components.has((DataComponentType)ModDataComponents.SOIL_COMPONENT.get())) {
                clone.set((DataComponentType)ModDataComponents.SOIL_COMPONENT.get(), (Object)((SoilDataComponent)components.get((DataComponentType)ModDataComponents.SOIL_COMPONENT.get())));
            }
            if (components.has((DataComponentType)ModDataComponents.SAPLING_COMPONENT.get())) {
                clone.set((DataComponentType)ModDataComponents.SAPLING_COMPONENT.get(), (Object)((SaplingDataComponent)components.get((DataComponentType)ModDataComponents.SAPLING_COMPONENT.get())));
            }
            if (components.has((DataComponentType)ModDataComponents.TOOL_COMPONENT.get())) {
                clone.set((DataComponentType)ModDataComponents.TOOL_COMPONENT.get(), (Object)((ToolDataComponent)components.get((DataComponentType)ModDataComponents.TOOL_COMPONENT.get())));
            }
            if (components.has(DataComponents.ENCHANTMENTS)) {
                clone.set(DataComponents.ENCHANTMENTS, (Object)((ItemEnchantments)components.get(DataComponents.ENCHANTMENTS)));
            }
            if (components.has((DataComponentType)ModDataComponents.REDSTONEMODE_COMPONENT.get())) {
                clone.set((DataComponentType)ModDataComponents.REDSTONEMODE_COMPONENT.get(), (Object)((RedstoneModeDataComponent)components.get((DataComponentType)ModDataComponents.REDSTONEMODE_COMPONENT.get())));
            }
            return clone;
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    protected int getLightBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getLightEmission(state, level, pos);
    }

    public boolean hasDynamicLightEmission(BlockState state) {
        return true;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BonsaiPotBlockEntity) {
            BonsaiInfo info;
            BonsaiPotBlockEntity bonsaiPot = (BonsaiPotBlockEntity)blockEntity;
            if (bonsaiPot.production.getBonsaiInfo().isPresent() && (info = bonsaiPot.production.getBonsaiInfo().get()).lightEmission().isPresent()) {
                return info.lightEmission().get();
            }
        }
        return 0;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.isClientSide()) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BonsaiPotBlockEntity) {
            ItemStack stackAfterClick;
            BonsaiPotBlockEntity bonsaiPot = (BonsaiPotBlockEntity)blockEntity;
            ItemStack stackBeforeClick = stack.copy();
            if (ItemStack.matches((ItemStack)stackBeforeClick, (ItemStack)(stackAfterClick = bonsaiPot.onItemClicked(stack, player, hand)))) {
                player.openMenu(state.getMenuProvider(level, pos), pos);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BonsaiPotBlockEntity) {
            BonsaiPotBlockEntity bonsaiPot = (BonsaiPotBlockEntity)blockEntity;
            player.openMenu(state.getMenuProvider(level, pos), pos);
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    @Nullable
    protected MenuProvider getMenuProvider(BlockState state, Level level, BlockPos pos) {
        return new SimpleMenuProvider((id, inventory, player) -> new BonsaiPotContainer(id, pos, inventory, player), (Component)Component.translatable((String)"container.bonsaitrees4.bonsai_pot"));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BonsaiPotBlockEntity(blockPos, blockState);
    }

    protected VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.SHAPE;
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.SHAPE;
    }

    protected VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return this.SHAPE;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.SHAPE;
    }

    protected MapCodec<? extends Block> codec() {
        return (MapCodec)ModBlocks.BONSAI_POT_TYPE.get();
    }

    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.HEAD;
    }
}

