/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.client.multiblock;

import com.davenonymous.bonsaitrees.client.multiblock.MultiBlockAmbientOcclusionFace;
import com.davenonymous.bonsaitrees.client.multiblock.MultiBlockBakedQuad;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.BitSet;
import java.util.List;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;

public class MultiBlockRenderer
extends ModelBlockRenderer {
    BlockAndTintGetter realLevel;
    BlockPos lightAndTintPosition;
    boolean isItemRender = false;

    public MultiBlockRenderer(BlockColors pBlockColors, BlockAndTintGetter realLevel, BlockPos lightAndTintPosition, boolean isItemRender) {
        super(pBlockColors);
        this.realLevel = realLevel;
        this.lightAndTintPosition = lightAndTintPosition;
        this.isItemRender = isItemRender;
    }

    public void putQuadData(BlockAndTintGetter level, BlockState state, BlockPos pos, VertexConsumer consumer, PoseStack.Pose pose, BakedQuad quad, float brightness0, float brightness1, float brightness2, float brightness3, int lightmap0, int lightmap1, int lightmap2, int lightmap3, int packedOverlay) {
        if (quad instanceof MultiBlockBakedQuad) {
            MultiBlockBakedQuad q = (MultiBlockBakedQuad)quad;
            float r = 1.0f;
            float g = 1.0f;
            float b = 1.0f;
            if (quad.isTinted()) {
                int i = this.blockColors.getColor(q.state, level, pos, quad.getTintIndex());
                r = (float)(i >> 16 & 0xFF) / 255.0f;
                g = (float)(i >> 8 & 0xFF) / 255.0f;
                b = (float)(i & 0xFF) / 255.0f;
            }
            consumer.putBulkData(pose, quad, new float[]{brightness0, brightness1, brightness2, brightness3}, r, g, b, 1.0f, new int[]{lightmap0, lightmap1, lightmap2, lightmap3}, packedOverlay, true);
            return;
        }
        super.putQuadData(level, state, pos, consumer, pose, quad, brightness0, brightness1, brightness2, brightness3, lightmap0, lightmap1, lightmap2, lightmap3, packedOverlay);
    }

    public void renderModelFaceAO(BlockAndTintGetter pLevel, BlockState pState, BlockPos pPos, PoseStack pPoseStack, VertexConsumer pConsumer, List<BakedQuad> pQuads, float[] pShape, BitSet pShapeFlags, ModelBlockRenderer.AmbientOcclusionFace pAoFace, int pPackedOverlay) {
        float[] shape = new float[12];
        BitSet shapeFlags = new BitSet(3);
        shapeFlags.set(1, false);
        int levelColor = LevelRenderer.getLightColor((BlockAndTintGetter)this.realLevel, (BlockPos)this.lightAndTintPosition);
        for (BakedQuad bakedquad : pQuads) {
            BlockState state = pState;
            BlockPos pos = pPos;
            float[] brightness = pAoFace.brightness;
            int[] lightmap = pAoFace.lightmap;
            if (bakedquad instanceof MultiBlockBakedQuad) {
                MultiBlockBakedQuad q = (MultiBlockBakedQuad)bakedquad;
                state = q.state;
                pos = q.pos;
                if (q.aoFace == null) {
                    MultiBlockAmbientOcclusionFace face = new MultiBlockAmbientOcclusionFace();
                    face.calculate(pLevel, state, pos, bakedquad.getDirection(), shape, shapeFlags, bakedquad.isShade());
                    q.aoFace = face;
                }
                brightness = q.aoFace.brightness;
                lightmap = q.aoFace.lightmap;
            }
            float b1 = Math.min(1.0f, brightness[0] + 0.2f);
            float b2 = Math.min(1.0f, brightness[1] + 0.2f);
            float b3 = Math.min(1.0f, brightness[2] + 0.2f);
            float b4 = Math.min(1.0f, brightness[3] + 0.2f);
            int l1 = lightmap[0] + levelColor >> 1;
            int l2 = lightmap[1] + levelColor >> 1;
            int l3 = lightmap[2] + levelColor >> 1;
            int l4 = lightmap[3] + levelColor >> 1;
            if (this.isItemRender) {
                l1 = 0xFF00FF;
                l2 = 0xFF00FF;
                l3 = 0xFF00FF;
                l4 = 0xFF00FF;
            }
            this.putQuadData(pLevel, state, pos, pConsumer, pPoseStack.last(), bakedquad, b1, b2, b3, b4, l1, l2, l3, l4, pPackedOverlay);
        }
    }

    public void renderModelFaceFlat(BlockAndTintGetter pLevel, BlockState pState, BlockPos pPos, int pPackedLight, int pPackedOverlay, boolean pRepackLight, PoseStack pPoseStack, VertexConsumer pConsumer, List<BakedQuad> pQuads, BitSet pShapeFlags) {
        float[] shape = new float[12];
        BitSet shapeFlags = new BitSet(3);
        for (BakedQuad bakedquad : pQuads) {
            BlockState state = pState;
            BlockPos pos = pPos;
            if (bakedquad instanceof MultiBlockBakedQuad) {
                MultiBlockBakedQuad q = (MultiBlockBakedQuad)bakedquad;
                state = q.state;
                pos = q.pos;
            }
            if (pRepackLight) {
                this.calculateShape(pLevel, state, pos, bakedquad.getVertices(), bakedquad.getDirection(), shape, shapeFlags);
                BlockPos blockpos = shapeFlags.get(0) ? pos.relative(bakedquad.getDirection()) : pos;
                pPackedLight = LevelRenderer.getLightColor((BlockAndTintGetter)pLevel, (BlockState)state, (BlockPos)blockpos);
            }
            float f = pLevel.getShade(bakedquad.getDirection(), bakedquad.isShade());
            this.putQuadData(pLevel, state, pos, pConsumer, pPoseStack.last(), bakedquad, f, f, f, f, pPackedLight, pPackedLight, pPackedLight, pPackedLight, pPackedOverlay);
        }
    }
}

