/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.command.place;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class PlacementHelper<T extends BlockEntity> {
    public BlockState background = Blocks.BLACK_CONCRETE.defaultBlockState();
    public int extent = 32;
    public float aspectRatio = 1.7777778f;
    public boolean ascendingHeight = false;
    public int total;
    public BlockPos pos;
    public ServerLevel world;
    private int index = 0;
    private int columns;
    private int rows;

    public PlacementHelper(BlockPos pos, ServerLevel world, int total) {
        this.pos = pos;
        this.world = world;
        this.total = total;
        this.columns = (int)Math.ceil(Math.sqrt((float)total * this.aspectRatio));
        this.rows = (int)Math.ceil((float)total / (float)this.columns);
        if (this.columns <= 0) {
            this.columns = 1;
        }
        if (this.rows <= 0) {
            this.rows = 1;
        }
    }

    public void placeArena() {
        for (int column = -this.extent; column < this.columns + this.extent; ++column) {
            for (int row = -this.extent; row < this.rows + this.extent; ++row) {
                BlockPos displayPos = this.pos.offset(column, this.ascendingHeight ? row : 0, row);
                this.world.setBlock(displayPos, this.background, 3);
            }
        }
    }

    public void placeNextBlock(BlockState state, Consumer<T> processEntity) {
        int column = this.index % this.columns;
        int row = this.index / this.columns;
        BlockPos placePos = this.pos.offset(column, this.ascendingHeight ? row : 0, row);
        this.world.setBlock(placePos.above(), state, 3);
        BlockEntity blockEntity = this.world.getBlockEntity(placePos.above());
        processEntity.accept(blockEntity);
        ++this.index;
        if (this.ascendingHeight) {
            for (int height = row - 1; height >= 0; --height) {
                BlockPos displayPos = this.pos.offset(column, height, row);
                this.world.setBlock(displayPos, this.background, 3);
            }
        }
    }
}

