/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.lib.gui;

import com.davenonymous.bonsaitrees.lib.gui.WidgetContainer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class WidgetBlockEntityContainer<T extends BlockEntity>
extends WidgetContainer {
    protected T blockEntity;

    protected WidgetBlockEntityContainer(@Nullable MenuType<?> type, int id, BlockPos pos, Inventory inv, @NotNull Player player) {
        super(type, id, inv);
        BlockEntity uncastEntity = player.getCommandSenderWorld().getBlockEntity(pos);
        if (uncastEntity != null) {
            this.blockEntity = uncastEntity;
        }
    }

    @Override
    public boolean stillValid(Player playerEntity) {
        Level level;
        if (this.blockEntity != null && (level = this.blockEntity.getLevel()) != null) {
            ContainerLevelAccess callable = ContainerLevelAccess.create((Level)level, (BlockPos)this.blockEntity.getBlockPos());
            return WidgetBlockEntityContainer.stillValid((ContainerLevelAccess)callable, (Player)playerEntity, (Block)this.blockEntity.getBlockState().getBlock());
        }
        return false;
    }

    public T getBlockEntity() {
        return this.blockEntity;
    }
}

