/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.lib.gui.tooltip;

import com.davenonymous.bonsaitrees.lib.gui.tooltip.HBoxTooltipComponent;
import com.davenonymous.bonsaitrees.lib.gui.tooltip.IngredientTooltipComponent;
import com.davenonymous.bonsaitrees.lib.gui.tooltip.StringTooltipComponent;
import com.davenonymous.bonsaitrees.lib.gui.tooltip.TranslatableTooltipComponent;
import com.davenonymous.bonsaitrees.lib.gui.tooltip.VBoxTooltipComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class IngredientBoxTooltipComponent
implements TooltipComponent,
ClientTooltipComponent {
    private final List<Ingredient> items;
    private int columns = 9;
    private int maxRows = 3;
    private int padding = 1;
    private VBoxTooltipComponent container;

    public IngredientBoxTooltipComponent(Ingredient ... items) {
        this.items = new ArrayList<Ingredient>();
        Collections.addAll(this.items, items);
        this.rebuild();
    }

    public IngredientBoxTooltipComponent(Collection<Item> items) {
        this.items = items.stream().map(xva$0 -> Ingredient.of((ItemLike[])new ItemLike[]{xva$0})).toList();
        this.rebuild();
    }

    public IngredientBoxTooltipComponent setPadding(int padding) {
        this.padding = padding;
        this.rebuild();
        return this;
    }

    public IngredientBoxTooltipComponent setColumns(int columns) {
        this.columns = columns;
        this.rebuild();
        return this;
    }

    public IngredientBoxTooltipComponent setMaxRows(int maxRows) {
        this.maxRows = maxRows;
        this.rebuild();
        return this;
    }

    public IngredientBoxTooltipComponent rebuild() {
        this.container = new VBoxTooltipComponent(new TooltipComponent[0]).setPadding(this.padding);
        int shown = 0;
        ArrayList finalTooltipStacks = new ArrayList();
        HBoxTooltipComponent hbox = new HBoxTooltipComponent(new TooltipComponent[0]).setPadding(this.padding);
        for (Ingredient ingredient : this.items) {
            if (shown >= this.maxRows * this.columns - 1) {
                Collections.addAll(finalTooltipStacks, ingredient.getItems());
                continue;
            }
            if (hbox.count() >= this.columns) {
                this.container.add(hbox);
                hbox = new HBoxTooltipComponent(new TooltipComponent[0]).setPadding(this.padding);
            }
            IngredientTooltipComponent ingredientTooltipComponent = new IngredientTooltipComponent(ingredient);
            ingredientTooltipComponent.setShowLabel(false);
            hbox.add(ingredientTooltipComponent);
            ++shown;
        }
        if (!finalTooltipStacks.isEmpty()) {
            IngredientTooltipComponent ingTT = new IngredientTooltipComponent(Ingredient.of(finalTooltipStacks.stream()));
            ingTT.setShowLabel(false);
            hbox.add(ingTT);
        }
        this.container.add(hbox);
        if (!finalTooltipStacks.isEmpty()) {
            this.container.add(StringTooltipComponent.white(""));
            this.container.add(new TranslatableTooltipComponent("bonsaitrees4.tooltip.and_more", null, new Object[]{finalTooltipStacks.size()}));
        }
        return this;
    }

    public int getHeight() {
        return this.container.getHeight();
    }

    public int getWidth(Font font) {
        return this.container.getWidth(font);
    }

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        this.container.renderImage(font, x, y, guiGraphics);
    }
}

