/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.lib.util;

import com.davenonymous.bonsaitrees.BonsaiTrees;
import com.davenonymous.bonsaitrees.lib.gui.GUI;
import com.davenonymous.bonsaitrees.lib.gui.tooltip.BoxAlignment;
import com.davenonymous.bonsaitrees.lib.gui.tooltip.HBoxTooltipComponent;
import com.davenonymous.bonsaitrees.lib.gui.tooltip.IngredientTooltipComponent;
import com.davenonymous.bonsaitrees.lib.gui.tooltip.ItemStackTooltipComponent;
import com.davenonymous.bonsaitrees.lib.gui.tooltip.SpriteTooltipComponent;
import com.davenonymous.bonsaitrees.lib.gui.tooltip.StringTooltipComponent;
import com.davenonymous.bonsaitrees.lib.gui.tooltip.TranslatableTooltipComponent;
import com.davenonymous.bonsaitrees.lib.gui.tooltip.VBoxTooltipComponent;
import com.davenonymous.bonsaitrees.setup.cache.ItemAbilityCache;
import com.davenonymous.bonsaitrees.setup.config.DebugConfig;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemEnchantmentsPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.CompositeEntryBase;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.loot.CanItemPerformAbility;

public class LootHelper {
    public static List<LootTableDrop> getLootTableDrops(Either<ResourceKey<LootTable>, LootTable> lootTable, ServerLevel level, LootContext lootContext) {
        return LootHelper.getLootTableDrops(lootTable, new LinkedList<LootItemCondition>(), 1, level, lootContext);
    }

    public static List<LootTableDrop> getLootTableDrops(Either<ResourceKey<LootTable>, LootTable> lootTable, List<LootItemCondition> conditions, int rolls, ServerLevel level, LootContext lootContext) {
        if (lootTable.left().isPresent()) {
            return LootHelper.getLootTableDrops((ResourceKey<LootTable>)((ResourceKey)lootTable.left().get()), conditions, rolls, level, lootContext);
        }
        if (lootTable.right().isPresent()) {
            return LootHelper.getLootTableDrops((LootTable)lootTable.right().get(), conditions, rolls, level, lootContext);
        }
        return new LinkedList<LootTableDrop>();
    }

    public static List<LootTableDrop> getLootTableDrops(ResourceKey<LootTable> lootTableId, ServerLevel level, LootContext lootContext) {
        return LootHelper.getLootTableDrops(lootTableId, new LinkedList<LootItemCondition>(), 1, level, lootContext);
    }

    public static List<LootTableDrop> getLootTableDrops(ResourceKey<LootTable> lootTableId, List<LootItemCondition> conditions, int rolls, ServerLevel level, LootContext lootContext) {
        LootTable lootTable = level.getServer().reloadableRegistries().getLootTable(lootTableId);
        return LootHelper.getLootTableDrops(lootTable, conditions, rolls, level, lootContext);
    }

    public static List<LootTableDrop> getLootTableDrops(LootTable lootTable, List<LootItemCondition> inheritedConditions, int rolls, ServerLevel level, LootContext lootContext) {
        LinkedList<LootTableDrop> drops = new LinkedList<LootTableDrop>();
        for (LootPool pool : lootTable.pools) {
            LinkedList conditionsForPool = new LinkedList(pool.conditions);
            LinkedList entryQueue = new LinkedList(pool.entries);
            int poolRolls = (int)Math.floor(pool.getRolls().getFloat(lootContext));
            while (!entryQueue.isEmpty()) {
                LootPoolEntryContainer entry = (LootPoolEntryContainer)entryQueue.poll();
                LinkedList<LootItemCondition> conditionsForEntry = new LinkedList<LootItemCondition>(inheritedConditions);
                conditionsForEntry.addAll(entry.conditions);
                conditionsForEntry.addAll(conditionsForPool);
                if (entry instanceof NestedLootTable) {
                    NestedLootTable nestedEntry = (NestedLootTable)entry;
                    Either nestedTable = nestedEntry.contents;
                    List<LootTableDrop> nestedDrops = LootHelper.getLootTableDrops((Either<ResourceKey<LootTable>, LootTable>)nestedTable, conditionsForEntry, poolRolls * rolls, level, lootContext);
                    for (LootTableDrop nestedDrop : nestedDrops) {
                        if (drops.stream().anyMatch(drop -> ItemStack.isSameItem((ItemStack)nestedDrop.stack(), (ItemStack)drop.stack())) || nestedDrop.stack().isEmpty()) continue;
                        drops.add(nestedDrop);
                    }
                    continue;
                }
                if (entry instanceof CompositeEntryBase) {
                    CompositeEntryBase compositeEntry = (CompositeEntryBase)entry;
                    entryQueue.addAll(compositeEntry.children);
                    continue;
                }
                if (entry instanceof LootPoolSingletonContainer) {
                    LootPoolSingletonContainer container = (LootPoolSingletonContainer)entry;
                    container.createItemStack(itemStack -> {
                        if (itemStack.isEmpty()) {
                            return;
                        }
                        Set<Class<LootItemKilledByPlayerCondition>> conditionClasses = Set.of(ExplosionCondition.class, LootItemBlockStatePropertyCondition.class, LootItemEntityPropertyCondition.class, LootItemKilledByPlayerCondition.class);
                        LinkedList<LootItemCondition> filteredConditions = new LinkedList<LootItemCondition>(conditionsForEntry.stream().filter(cond -> !conditionClasses.contains(cond.getClass())).toList());
                        ItemStack dropItem = itemStack.copy();
                        dropItem.setCount(rolls);
                        drops.add(new LootTableDrop(dropItem, filteredConditions));
                    }, lootContext);
                    continue;
                }
                BonsaiTrees.LOGGER.warn("Unknown loot pool entry: {}", (Object)entry);
            }
        }
        return drops;
    }

    public static Optional<LootItemRandomChanceCondition> getLootCondition(LootPool pool) {
        for (LootItemCondition condition : pool.conditions) {
            if (!(condition instanceof LootItemRandomChanceCondition)) continue;
            LootItemRandomChanceCondition chanceCondition = (LootItemRandomChanceCondition)condition;
            return Optional.of(chanceCondition);
        }
        return Optional.empty();
    }

    /*
     * Loose catch block
     */
    public static TooltipComponent interpretCondition(LootItemCondition pCondition) {
        if (pCondition instanceof InvertedLootItemCondition) {
            LootItemCondition lootItemCondition;
            InvertedLootItemCondition invertedLootItemCondition = (InvertedLootItemCondition)pCondition;
            LootItemCondition term = lootItemCondition = invertedLootItemCondition.term();
            TooltipComponent nested = LootHelper.interpretCondition(term);
            if (nested == null) {
                return null;
            }
            SpriteTooltipComponent sprite = new SpriteTooltipComponent(GUI.tabIcons, 14, 11, 118, 0);
            return new HBoxTooltipComponent(sprite, nested).setAlignment(BoxAlignment.CENTER);
        }
        if (pCondition instanceof LootItemRandomChanceCondition) {
            block29: {
                NumberProvider nested;
                LootItemRandomChanceCondition lootItemRandomChanceCondition = (LootItemRandomChanceCondition)pCondition;
                NumberProvider chance = nested = lootItemRandomChanceCondition.chance();
                if (!DebugConfig.showChances) break block29;
                if (chance instanceof ConstantValue) {
                    float f;
                    nested = (ConstantValue)chance;
                    float value = f = nested.value();
                    return StringTooltipComponent.gray("Chance: " + value * 100.0f + "%");
                }
                return StringTooltipComponent.gray("UnknownChance: " + chance.getClass().getSimpleName());
            }
            return null;
        }
        if (pCondition instanceof AnyOfCondition) {
            AnyOfCondition condition = (AnyOfCondition)pCondition;
            VBoxTooltipComponent conditionList = new VBoxTooltipComponent(new TooltipComponent[0]);
            for (LootItemCondition term : condition.terms) {
                TooltipComponent component = LootHelper.interpretCondition(term);
                if (component == null) continue;
                conditionList.add(component);
            }
            return conditionList;
        }
        if (pCondition instanceof CanItemPerformAbility) {
            CanItemPerformAbility condition = (CanItemPerformAbility)pCondition;
            try {
                Field abilityField = CanItemPerformAbility.class.getDeclaredField("ability");
                abilityField.setAccessible(true);
                ItemAbility ability = (ItemAbility)abilityField.get(condition);
                Ingredient items = ItemAbilityCache.getIngredientForAbility(ability);
                return new IngredientTooltipComponent(items);
            }
            catch (NoSuchFieldException abilityField) {
            }
            catch (IllegalAccessException abilityField) {
                // empty catch block
            }
            return null;
        }
        if (pCondition instanceof ExplosionCondition) {
            ExplosionCondition condition = (ExplosionCondition)pCondition;
            return null;
        }
        if (pCondition instanceof LootItemBlockStatePropertyCondition) {
            LootItemBlockStatePropertyCondition condition = (LootItemBlockStatePropertyCondition)pCondition;
            return null;
        }
        if (pCondition instanceof MatchTool) {
            MatchTool condition = (MatchTool)pCondition;
            if (condition.predicate().isEmpty()) {
                return null;
            }
            ItemPredicate predicate = (ItemPredicate)condition.predicate().get();
            VBoxTooltipComponent conditionList = new VBoxTooltipComponent(new TooltipComponent[0]);
            if (predicate.items().isPresent()) {
                HolderSet items = (HolderSet)predicate.items().get();
                Ingredient ingredient = Ingredient.of(items.stream().map(ItemStack::new));
                conditionList.add(new IngredientTooltipComponent(ingredient));
            }
            for (ItemSubPredicate subPredicate : predicate.subPredicates().values()) {
                if (subPredicate instanceof ItemEnchantmentsPredicate) {
                    ItemEnchantmentsPredicate enchantmentsPredicate = (ItemEnchantmentsPredicate)subPredicate;
                    for (EnchantmentPredicate enchantmentPredicate : enchantmentsPredicate.enchantments) {
                        if (enchantmentPredicate.enchantments().isEmpty()) continue;
                        HolderSet enchantments = (HolderSet)enchantmentPredicate.enchantments().get();
                        for (Holder enchantment : enchantments) {
                            ItemStackTooltipComponent book = new ItemStackTooltipComponent(new ItemStack((ItemLike)Items.ENCHANTED_BOOK)).setShowLabel(false);
                            TranslatableTooltipComponent label = new TranslatableTooltipComponent(((Enchantment)enchantment.value()).description().getString());
                            conditionList.add(new HBoxTooltipComponent(book, label).setAlignment(BoxAlignment.END));
                        }
                    }
                    continue;
                }
                BonsaiTrees.LOGGER.warn("Unknown SubPredicate: {}", (Object)subPredicate.getClass().getSimpleName());
            }
            if (conditionList.isEmpty()) {
                return null;
            }
            return conditionList;
        }
        if (pCondition instanceof BonusLevelTableCondition) {
            BonusLevelTableCondition condition = (BonusLevelTableCondition)pCondition;
            if (condition.values().isEmpty()) {
                return null;
            }
            Holder enchantment = condition.enchantment();
            float baseChance = ((Float)condition.values().getFirst()).floatValue();
            if (baseChance == 0.0f) {
                ItemStackTooltipComponent book = new ItemStackTooltipComponent(new ItemStack((ItemLike)Items.ENCHANTED_BOOK)).setShowLabel(false);
                TranslatableTooltipComponent label = new TranslatableTooltipComponent(((Enchantment)enchantment.value()).description().getString());
                return new HBoxTooltipComponent(book, label).setAlignment(BoxAlignment.END);
            }
            if (DebugConfig.showChances) {
                return StringTooltipComponent.gray("Chance: " + baseChance * 100.0f + "%");
            }
            return null;
        }
        if (DebugConfig.showUnknownLootConditions) {
            return new HBoxTooltipComponent(new TranslatableTooltipComponent("jei.bonsaitrees4.recipes.unknown_condition"), StringTooltipComponent.gray(pCondition.getClass().getSimpleName()));
        }
        return null;
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    public static class LootTableDrop {
        private ItemStack stack;
        private List<LootItemCondition> conditions;
        public static final StreamCodec<RegistryFriendlyByteBuf, LootTableDrop> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, LootTableDrop::stack, (StreamCodec)ByteBufCodecs.fromCodecWithRegistries((Codec)LootItemCondition.DIRECT_CODEC).apply(ByteBufCodecs.list()), LootTableDrop::conditions, LootTableDrop::new);

        public ItemStack stack() {
            return this.stack;
        }

        public LootTableDrop stack(ItemStack stack) {
            this.stack = stack;
            return this;
        }

        public List<LootItemCondition> conditions() {
            return this.conditions;
        }

        public LootTableDrop addConditions(List<LootItemCondition> conditions) {
            this.conditions.addAll(conditions);
            return this;
        }

        public LootTableDrop conditions(List<LootItemCondition> conditions) {
            this.conditions = conditions;
            return this;
        }

        public LootTableDrop(ItemStack stack, List<LootItemCondition> conditions) {
            this.stack = stack;
            this.conditions = conditions;
        }
    }
}

