/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.multiblock;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class MultiBlockGeometryBase {
    public static final MultiBlockGeometryBase EMPTY = new MultiBlockGeometryBase(4, Collections.emptyMap(), Collections.emptyList(), 1, 0);
    public static final MapCodec<MultiBlockGeometryBase> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("version").forGetter(MultiBlockGeometryBase::version), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)BlockState.CODEC).fieldOf("ref").forGetter(MultiBlockGeometryBase::ref), (App)Codec.list((Codec)Codec.list((Codec)Codec.STRING)).fieldOf("shape").forGetter(MultiBlockGeometryBase::shape), (App)Codec.INT.optionalFieldOf("scaleToBlocks", (Object)1).forGetter(MultiBlockGeometryBase::scaleToBlocks), (App)Codec.INT.optionalFieldOf("lightEmission", (Object)0).forGetter(MultiBlockGeometryBase::lightEmission)).apply((Applicative)instance, MultiBlockGeometryBase::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MultiBlockGeometryBase> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, MultiBlockGeometryBase::version, (StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.STRING_UTF8, (StreamCodec)ByteBufCodecs.fromCodecWithRegistries((Codec)BlockState.CODEC)), MultiBlockGeometryBase::ref, (StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list()).apply(ByteBufCodecs.list()), MultiBlockGeometryBase::shape, (StreamCodec)ByteBufCodecs.INT, MultiBlockGeometryBase::scaleToBlocks, (StreamCodec)ByteBufCodecs.INT, MultiBlockGeometryBase::lightEmission, MultiBlockGeometryBase::new);
    private final int version;
    private final Map<String, BlockState> ref;
    private final List<List<String>> shape;
    private final int scaleToBlocks;
    private final Map<BlockPos, Voxel> voxels;
    private final int lightEmission;
    public final BlockPos trunkPos;

    public MultiBlockGeometryBase(int version, Map<String, BlockState> ref, List<List<String>> shape, int scaleToBlocks, int lightEmission) {
        this.version = version;
        this.ref = ref;
        this.shape = shape;
        this.scaleToBlocks = scaleToBlocks;
        this.voxels = this.getBlocks();
        this.trunkPos = this.getTrunkPos();
        this.lightEmission = lightEmission;
    }

    public int getBlockCount() {
        return this.voxels.keySet().size();
    }

    public int getStateCount() {
        return this.ref.keySet().size();
    }

    public static Map<BlockPos, Voxel> castVoxelMap(Map<BlockPos, BlockState> blocks) {
        HashMap<BlockPos, Voxel> voxels = new HashMap<BlockPos, Voxel>();
        for (Map.Entry<BlockPos, BlockState> entry : blocks.entrySet()) {
            BlockPos pos = entry.getKey();
            BlockState state = entry.getValue();
            voxels.put(pos, new Voxel(pos, state));
        }
        return voxels;
    }

    public MultiBlockGeometryBase(int scaleToBlocks, int version, Map<BlockPos, Voxel> blocks, int lightEmission) {
        this.scaleToBlocks = scaleToBlocks;
        this.version = version;
        this.voxels = blocks;
        int width = 0;
        int height = 0;
        int depth = 0;
        for (BlockPos pos : blocks.keySet()) {
            if (pos.getX() > width) {
                width = pos.getX();
            }
            if (pos.getY() > height) {
                height = pos.getY();
            }
            if (pos.getZ() <= depth) continue;
            depth = pos.getZ();
        }
        HashMap<BlockState, Character> refMap = new HashMap<BlockState, Character>();
        int refChar = 97;
        this.ref = new HashMap<String, BlockState>();
        char[][][] blocksAsArray = new char[width + 1][height + 1][depth + 1];
        for (int x2 = 0; x2 < width + 1; ++x2) {
            for (int y = 0; y < height + 1; ++y) {
                for (int z = 0; z < depth + 1; ++z) {
                    blocksAsArray[x2][y][z] = 32;
                }
            }
        }
        for (Map.Entry entry : blocks.entrySet().stream().sorted(Map.Entry.comparingByKey()).toList()) {
            char stateChar;
            BlockPos pos = (BlockPos)entry.getKey();
            Voxel state = (Voxel)entry.getValue();
            if (!refMap.containsKey(state.state())) {
                int n = refChar;
                refChar = (char)(refChar + 1);
                refMap.put(state.state(), Character.valueOf((char)n));
                this.ref.put(String.valueOf((char)refChar), state.state());
                if (refChar == 123) {
                    refChar = 65;
                }
            }
            blocksAsArray[pos.getX()][pos.getY()][pos.getZ()] = stateChar = ((Character)refMap.get(state.state())).charValue();
        }
        this.shape = Arrays.stream(blocksAsArray).map(x -> Arrays.stream(x).map(String::valueOf).toList()).toList();
        this.trunkPos = this.getTrunkPos();
        this.lightEmission = lightEmission;
    }

    public static MultiBlockGeometryBase forDataGen(Map<BlockPos, BlockState> blocks, int lightEmission) {
        return new MultiBlockGeometryBase(1, 4, MultiBlockGeometryBase.castVoxelMap(blocks), lightEmission);
    }

    private BlockPos getTrunkPos() {
        Vec3i size = this.getSize();
        BlockPos center = new BlockPos(size.getX() / 2, 0, size.getZ() / 2);
        ArrayList<BlockPos> roots = new ArrayList<BlockPos>();
        if (this.voxels.containsKey(center)) {
            roots.add(center);
        }
        for (BlockPos testPos : BlockPos.spiralAround((BlockPos)center, (int)3, (Direction)Direction.EAST, (Direction)Direction.NORTH)) {
            BlockState state;
            if (!this.voxels.containsKey(testPos) || (state = this.voxels.get((Object)testPos).state).isAir() || state.is(Blocks.WATER) || state.is(BlockTags.LEAVES)) continue;
            roots.add(new BlockPos(testPos.getX(), 0, testPos.getZ()));
        }
        if (roots.isEmpty()) {
            return center;
        }
        if (roots.size() == 1) {
            return (BlockPos)roots.getFirst();
        }
        if (roots.size() >= 4) {
            return center;
        }
        int x = 0;
        int z = 0;
        for (BlockPos root : roots) {
            x += root.getX();
            z += root.getZ();
        }
        center = new BlockPos(x / roots.size(), 0, z / roots.size());
        return center;
    }

    private Map<BlockPos, Voxel> getBlocks() {
        HashMap<BlockPos, Voxel> blocks = new HashMap<BlockPos, Voxel>();
        for (int x = 0; x < this.shape.size(); ++x) {
            List<String> slice = this.shape.get(x);
            for (int y = slice.size() - 1; y >= 0; --y) {
                String row = slice.get(y);
                for (int z = 0; z < row.length(); ++z) {
                    BlockState state;
                    String key = row.substring(z, z + 1);
                    if (key.equals(" ") || (state = this.ref.get(key)) == null) continue;
                    BlockPos pos = new BlockPos(this.shape.size() - 1 - x, slice.size() - 1 - y, z);
                    blocks.put(pos, new Voxel(pos, state));
                }
            }
        }
        return blocks;
    }

    public Vec3i getSize() {
        int maxX = 0;
        int maxY = 0;
        int maxZ = 0;
        for (Voxel voxel : this.voxels.values()) {
            BlockPos pos = voxel.pos();
            maxX = Math.max(maxX, pos.getX());
            maxY = Math.max(maxY, pos.getY());
            maxZ = Math.max(maxZ, pos.getZ());
        }
        return new Vec3i(maxX, maxY, maxZ);
    }

    public int getMaxDimension() {
        Vec3i size = this.getSize();
        return Math.max(size.getX(), Math.max(size.getY(), size.getZ()));
    }

    public int getMinDimension() {
        Vec3i size = this.getSize();
        return Math.min(size.getX(), Math.min(size.getY(), size.getZ()));
    }

    public int version() {
        return this.version;
    }

    public Map<String, BlockState> ref() {
        return this.ref;
    }

    public List<List<String>> shape() {
        return this.shape;
    }

    public int scaleToBlocks() {
        return this.scaleToBlocks;
    }

    public int lightEmission() {
        return this.lightEmission;
    }

    public Map<BlockPos, Voxel> voxels() {
        return this.voxels;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        MultiBlockGeometryBase that = (MultiBlockGeometryBase)obj;
        return this.version == that.version && Objects.equals(this.ref, that.ref) && Objects.equals(this.shape, that.shape) && this.scaleToBlocks == that.scaleToBlocks;
    }

    public int hashCode() {
        return Objects.hash(this.version, this.ref, this.shape, this.scaleToBlocks);
    }

    public String toString() {
        return "MultiBlockModelGeometry[version=" + this.version + ", ref=" + String.valueOf(this.ref) + ", shape=" + String.valueOf(this.shape) + ", scaleToBlocks=" + this.scaleToBlocks + "]";
    }

    public String serializePretty() {
        if (this.getSize().getX() + 1 == 0 || this.getSize().getY() + 1 == 0 || this.getSize().getZ() + 1 == 0) {
            return "";
        }
        char[][][] map = new char[this.getSize().getX() + 1][this.getSize().getY() + 1][this.getSize().getZ() + 1];
        StringBuilder refMapBuilder = new StringBuilder();
        refMapBuilder.append("  \"ref\": {\n");
        char nextRef = 'a';
        HashMap<String, Character> refMap = new HashMap<String, Character>();
        for (Map.Entry<BlockPos, Voxel> entry : this.voxels.entrySet()) {
            char thisRef;
            BlockPos pos = entry.getKey();
            BlockState state = entry.getValue().state();
            String jsonString = ((JsonElement)BlockState.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)state).result().get()).toString();
            if (refMap.containsKey(jsonString)) {
                thisRef = ((Character)refMap.get(jsonString)).charValue();
            } else {
                char c = nextRef;
                nextRef = (char)(nextRef + 1);
                thisRef = c;
                if (nextRef == '{') {
                    nextRef = 'A';
                }
                refMap.put(jsonString, Character.valueOf(thisRef));
                refMapBuilder.append("    \"" + thisRef + "\": " + jsonString + ",\n");
            }
            map[pos.getX()][pos.getY()][pos.getZ()] = thisRef;
        }
        refMapBuilder.deleteCharAt(refMapBuilder.length() - 2);
        refMapBuilder.append("  },\n");
        StringBuilder output = new StringBuilder("{\n");
        output.append("  \"loader\": \"bonsaitrees4:multiblockmodel\",\n");
        output.append("  \"version\": 4,\n");
        output.append((CharSequence)refMapBuilder);
        output.append("  \"shape\": [\n");
        for (int x = map.length - 1; x >= 0; --x) {
            output.append("    [\n");
            for (int y = map[x].length - 1; y >= 0; --y) {
                StringBuilder builder = new StringBuilder();
                for (int z = 0; z < map[x][y].length; ++z) {
                    char chr = ' ';
                    if (map[x][y][z] != '\u0000') {
                        chr = map[x][y][z];
                    }
                    builder.append(chr);
                }
                output.append("      \"" + String.valueOf(builder) + "\",\n");
            }
            output.deleteCharAt(output.length() - 2);
            output.append("    ],\n");
        }
        output.deleteCharAt(output.length() - 2);
        output.append("  ]\n}\n");
        return output.toString();
    }

    public record Voxel(BlockPos pos, BlockState state) {
        public BakedModel model() {
            return Minecraft.getInstance().getModelManager().getBlockModelShaper().getBlockModel(this.state);
        }
    }
}

