/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.setup;

import com.davenonymous.bonsaitrees.BonsaiTrees;
import com.davenonymous.bonsaitrees.client.PotModelLoader;
import com.davenonymous.bonsaitrees.client.multiblock.MultiBlockFakeLevel;
import com.davenonymous.bonsaitrees.client.multiblock.MultiBlockModel;
import com.davenonymous.bonsaitrees.client.multiblock.MultiBlockModelLoader;
import com.davenonymous.bonsaitrees.client.multiblock.MultiBlockRenderer;
import com.davenonymous.bonsaitrees.setup.ModBlocks;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;

@EventBusSubscriber(modid="bonsaitrees4", value={Dist.CLIENT})
public class ModModelLoaders {
    public static final Map<ResourceLocation, VertexBuffer> MULTIBLOCK_VBOS = new HashMap<ResourceLocation, VertexBuffer>();
    public static Map<ResourceLocation, ModelResourceLocation> MODEL_MAP = new HashMap<ResourceLocation, ModelResourceLocation>();
    public static RenderType renderTypeForModels = RenderType.cutout();

    public static VertexBuffer getVbo(ResourceLocation modelId, MultiBlockModel multiBlockModel, MultiBlockFakeLevel level, BlockPos pos) {
        if (!MULTIBLOCK_VBOS.containsKey(modelId)) {
            ByteBufferBuilder byteBufferBuilder = new ByteBufferBuilder(ModModelLoaders.renderTypeForModels.bufferSize);
            BufferBuilder bufferBuilder = new BufferBuilder(byteBufferBuilder, VertexFormat.Mode.QUADS, DefaultVertexFormat.BLOCK);
            MultiBlockRenderer renderer = new MultiBlockRenderer(Minecraft.getInstance().getBlockColors(), level, pos, true);
            PoseStack tempPoseStack = new PoseStack();
            renderer.tesselateWithAO(level, (BakedModel)multiBlockModel, ((Block)ModBlocks.BONSAI_POT.get()).defaultBlockState(), pos, tempPoseStack, (VertexConsumer)bufferBuilder, false, RandomSource.create(), 0L, 0xF000F0, ModelData.EMPTY, renderTypeForModels);
            MeshData meshData = bufferBuilder.build();
            if (meshData != null) {
                VertexBuffer modelVertexBuffer = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
                modelVertexBuffer.bind();
                modelVertexBuffer.upload(meshData);
                VertexBuffer.unbind();
                MULTIBLOCK_VBOS.put(modelId, modelVertexBuffer);
            }
        }
        return MULTIBLOCK_VBOS.get(modelId);
    }

    @SubscribeEvent
    public static void registerGeometryLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register(MultiBlockModelLoader.ID, (IGeometryLoader)MultiBlockModelLoader.INSTANCE);
        event.register(PotModelLoader.ID, (IGeometryLoader)PotModelLoader.INSTANCE);
    }

    @SubscribeEvent
    public static void registerAdditional(ModelEvent.RegisterAdditional event) {
        Set treeModels = Minecraft.getInstance().getResourceManager().listResources("models/multiblock", resource -> resource.getPath().endsWith(".json")).keySet();
        for (ResourceLocation treeModel : treeModels) {
            ResourceLocation modelId = ResourceLocation.fromNamespaceAndPath((String)treeModel.getNamespace(), (String)treeModel.getPath().replace(".json", "").replace("models/", ""));
            String[] itemParts = modelId.getPath().replace("multiblock/", "").split("/", 2);
            if (itemParts.length != 2) continue;
            ResourceLocation itemId = ResourceLocation.fromNamespaceAndPath((String)itemParts[0], (String)itemParts[1]);
            ModelResourceLocation modelResourceId = ModelResourceLocation.standalone((ResourceLocation)modelId);
            event.register(modelResourceId);
            MODEL_MAP.put(itemId, modelResourceId);
        }
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        BonsaiTrees.CONTAINER.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }
}

