/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.setup.data;

import com.davenonymous.bonsaitrees.BonsaiTrees;
import com.davenonymous.bonsaitrees.setup.ModRegistries;
import com.davenonymous.bonsaitrees.setup.cache.SoilCache;
import com.davenonymous.bonsaitrees.setup.config.GameplayConfig;
import com.davenonymous.bonsaitrees.setup.data.DefaultSoilTypes;
import com.davenonymous.bonsaitrees.setup.data.SoilInfo;
import com.davenonymous.bonsaitrees.setup.data.SoilType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.storage.loot.LootTable;

public record BonsaiInfo(ResourceLocation model, Optional<List<ResourceLocation>> validSoils, Optional<Integer> requiredTicks, Optional<Integer> lightEmission) {
    public static final Codec<BonsaiInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("model").forGetter(BonsaiInfo::model), (App)ResourceLocation.CODEC.listOf().optionalFieldOf("valid_soil_types").forGetter(BonsaiInfo::validSoils), (App)Codec.INT.optionalFieldOf("base_ticks").forGetter(BonsaiInfo::requiredTicks), (App)Codec.INT.optionalFieldOf("light_emission").forGetter(BonsaiInfo::lightEmission)).apply((Applicative)instance, BonsaiInfo::new));

    public static BonsaiInfo plain(ResourceLocation model) {
        return new BonsaiInfo(model, Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static BonsaiInfo of(ResourceLocation ... validSoils) {
        return new BonsaiInfo(null, Optional.of(Arrays.stream(validSoils).toList()), Optional.empty(), Optional.empty());
    }

    public int baseTicks() {
        return this.requiredTicks.orElse(GameplayConfig.baseGrowTicks);
    }

    public Optional<SoilInfo> firstMatchingSoil(Set<SoilInfo> soilInfos, BonsaiInfo bonsaiInfo) {
        if (soilInfos == null || soilInfos.isEmpty()) {
            return Optional.empty();
        }
        if (bonsaiInfo == null || bonsaiInfo.validSoils.isEmpty() || bonsaiInfo.validSoils.get().isEmpty()) {
            return Optional.empty();
        }
        return soilInfos.stream().filter(soilInfo -> bonsaiInfo.canGrowOnSoil(soilInfo.soilType())).findFirst();
    }

    public boolean canGrowOnSoil(List<ResourceLocation> soilInfos) {
        return soilInfos.stream().anyMatch(this::canGrowOnSoil);
    }

    public boolean canGrowOnSoil(Set<SoilInfo> soilInfos) {
        return soilInfos.stream().anyMatch(soilInfo -> this.canGrowOnSoil(soilInfo.soilType()));
    }

    public boolean canGrowOnSoil(ResourceLocation soilTypeId) {
        if (this.validSoils.isEmpty() && soilTypeId.equals((Object)BonsaiTrees.resource("dirt"))) {
            return true;
        }
        if (this.validSoils.isEmpty()) {
            return false;
        }
        if (this.validSoils.get().isEmpty()) {
            return false;
        }
        return this.validSoils.get().contains(soilTypeId);
    }

    public List<SoilType> validSoilTypes(RegistryAccess registryAccess) {
        Registry soilRegistry = registryAccess.registryOrThrow(ModRegistries.SOILTYPE_REGISTRY_KEY);
        if (this.validSoils.isEmpty()) {
            SoilType soil = (SoilType)soilRegistry.getOrThrow(DefaultSoilTypes.DIRT);
            return List.of(soil);
        }
        return this.validSoils.get().stream().map(arg_0 -> ((Registry)soilRegistry).get(arg_0)).toList();
    }

    public List<Item> validSoilItems(RegistryAccess registryAccess) {
        HashSet<Item> result = new HashSet<Item>();
        for (SoilType soil : this.validSoilTypes(registryAccess)) {
            Map<Item, Set<SoilInfo>> soilInfoMap = SoilCache.SOIL_BY_TYPE.get(soil.id());
            if (soilInfoMap == null || soilInfoMap.isEmpty()) continue;
            result.addAll(soilInfoMap.keySet());
        }
        return new ArrayList<Item>(result);
    }

    public ResourceKey<LootTable> lootTable() {
        ResourceLocation modelId = this.model();
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)BonsaiTrees.resource("bonsai/" + modelId.getNamespace() + "/" + modelId.getPath()));
    }

    @Override
    public String toString() {
        return String.format("BonsaiInfo{model=%s, baseTicks=%s, soilTypes=%s}", this.model, this.requiredTicks, this.validSoils);
    }

    public BonsaiInfo withModel(ResourceLocation model) {
        return new BonsaiInfo(model, this.validSoils, this.requiredTicks, this.lightEmission);
    }

    public BonsaiInfo withValidSoils(List<ResourceLocation> validSoils) {
        if (validSoils.isEmpty()) {
            return new BonsaiInfo(this.model, Optional.empty(), this.requiredTicks, this.lightEmission);
        }
        return new BonsaiInfo(this.model, Optional.of(validSoils), this.requiredTicks, this.lightEmission);
    }

    public BonsaiInfo withRequiredTicks(int requiredTicks) {
        return new BonsaiInfo(this.model, this.validSoils, Optional.of(requiredTicks), this.lightEmission);
    }

    public BonsaiInfo withLightEmission(int lightEmission) {
        return new BonsaiInfo(this.model, this.validSoils, this.requiredTicks, lightEmission == 0 ? Optional.empty() : Optional.of(lightEmission));
    }
}

