/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.api.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import org.jetbrains.annotations.Nullable;

public interface IBlockHooks {
    public static final Direction[] LIGHTNING_REDIRECTION_FACES = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.DOWN};
    public static final Direction[] NO_LIGHTNING_REDIRECTION_FACES = new Direction[0];

    @Nullable
    default public PathType getPathfindingType(BlockState state, BlockGetter context, BlockPos pos) {
        return null;
    }

    default public void onLightningStrike(BlockState state, Level level, BlockPos pos, LightningBolt lightning) {
    }

    default public void onLightningStrikeIndirect(BlockState state, Level level, BlockPos pos, LightningBolt lightning, BlockPos strikeOrigin) {
    }

    default public Direction[] redirectLightningStrike(BlockState state, Level level, BlockPos pos) {
        return NO_LIGHTNING_REDIRECTION_FACES;
    }
}

